<?php $__env->startSection('title','Task Types'); ?>
<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
<div class="row page-titles">
    <div class="col-md-5 col-12 align-self-center">
        <h3 class="text-themecolor mb-0">Task Types</h3>
        <ol class="breadcrumb mb-0 p-0 bg-transparent">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Admin</a></li>
            <li class="breadcrumb-item active">Task Types</li>
        </ol>
    </div>
   
</div>
<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">
   <div class="row">
        <div class="col-12">
            <?php echo $__env->make('partials.notifications', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">Task Types</h4>
                    <h6 class="card-subtitle"></h6>
                    <button type="button" class="btn btn-info btn-rounded m-t-10 mb-2 float-right"
                        data-toggle="modal" data-target="#myModal">Add New Task Type</button>
                       <!-- Signup modal content -->
                    <div id="myModal" class="modal fade" tabindex="-1" role="dialog"
                        aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">

                                <div class="modal-body">
                                    <div class="text-center mt-2 mb-4">
                                        <h4 class="modal-title" id="myModalLabel">Add Task Type</h4>
                                    </div>

                                    <form class="pl-3 pr-3" action="<?php echo e(url('admin/task_types/add')); ?>" method="post">
                                     <?php echo csrf_field(); ?>

                                        <div class="form-group">
                                            <label for="username">Name</label>
                                            <input class="form-control" type="text" name="name" id="name"
                                                required="" placeholder="Name">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Status</label>
                                            <select class="form-control" required="" name="status">
                                                <option value="">Select</option>
                                                <option value="1">Active</option>
                                                <option value="0">Inactive</option>
                                            </select>
                                        </div>


                                      
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-light"
                                                data-dismiss="modal">Close</button>
                                            <button type="submit" class="btn btn-primary">Save</button>
                                        </div>

                                    </form>

                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->
                    <div class="table-responsive">
                        <table
                            class="table table-bordered m-t-30 table-hover contact-list table1" data-paging="true"
                            data-paging-size="7">
                            <thead>
                                <tr>
          
                                    <th>Name</th>
                                    <th>Updated at</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $task_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($task_type->name); ?></td>
                                    <td><?php echo e(date('d M Y',strtotime($task_type->updated_at))); ?></td>
                                     <td>
                                        <?php if($task_type->status == 1): ?>
                                        <span class="badge badge-success">Active</span>
                                        <?php else: ?>
                                        <span class="badge badge-danger">Pending</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                    
                                    <a class="edit" title="Edit" style="cursor:pointer;" data-id="<?php echo e($task_type->id); ?>"> <i class="fas fa-pencil-alt text-inverse m-r-10"></i> </a>
                                        <a href="<?php echo e(URL::to('admin/task_types/' . $task_type->id . '/delete')); ?>" onclick="return confirm('Do you want to delete this task_type?')" title="Delete"> <i class="fas fa-window-close text-danger"></i> </a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <?php echo e($task_types->render()); ?>

                </div>
            </div>
        </div>
    </div>
</div>
<!-- Signup modal content -->
<div id="editmodal" class="modal fade" tabindex="-1" role="dialog"
    aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
           <div class="text-center mt-2 mb-4">
                <h4 class="modal-title" id="myModalLabel">Edit Task Type</h4>
            </div>
            <div class="modal-body load_view" id="load_view">
               
            </div>
           
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascripts'); ?>
<script type="text/javascript">
$(function(){
    $('.edit').on('click',function(){
        id = $(this).data('id');       
        $('.load_view').load('<?php echo e(URL::to("admin/task_types/")); ?>/'+id+'/edit');
        $('#editmodal').modal('show');
    });
})
</script> 
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layout.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/devneoli/public_html/tms/resources/views/admin/task_types/index.blade.php ENDPATH**/ ?>