<?php $__env->startSection('title','Tasks'); ?>
<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
<div class="row page-titles">
    <div class="col-md-5 col-12 align-self-center">
        <h3 class="text-themecolor mb-0">Tasks</h3>
        <ol class="breadcrumb mb-0 p-0 bg-transparent">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Admin</a></li>
            <li class="breadcrumb-item active">Tasks</li>
        </ol>
    </div>
   
</div>
<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">
   <div class="row">
        <div class="col-12">
            <?php echo $__env->make('partials.notifications', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">Tasks</h4>
                    <h6 class="card-subtitle"></h6>
       
                    <form class="pl-3 pr-3" action="<?php echo e(url('admin/tasks/edit')); ?>" method="post" enctype="multipart/form-data">
                     <?php echo csrf_field(); ?>

                        <input type="hidden" name="id" value="<?php echo e($task->id); ?>">
                         <div class="form-group">
                            <label for="username">Name</label>
                            <input class="form-control" type="text" name="name" id="name"
                                required="" placeholder="Name" value="<?php echo e($task->name); ?>">
                        </div>
                        <div class="form-group">
                            <label for="username">IN/OUT</label>
                            <select class="form-control" required="" name="in_out">
                                <option value="">Select</option>
                                <option value="IN"  <?php if($task->in_out == "IN"){ echo "selected"; } ?>>IN</option>
                                <option value="OUT"  <?php if($task->in_out == "OUT"){ echo "selected"; } ?>>OUT</option>
                                <option value="CC"  <?php if($task->in_out == "CC"){ echo "selected"; } ?>>CC</option>
                                <option value="SELF"  <?php if($task->in_out == "SELF"){ echo "selected"; } ?>>SELF</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="username">Task Type</label>
                            <select class="form-control" required="" name="task_type_id">
                                <option value="">Select</option>
                                <?php $__currentLoopData = $task_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($task_type->id); ?>"  <?php echo e(($task->task_type_id == $task_type->id)? 'selected':''); ?>><?php echo e($task_type->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="username">Division</label>
                            <select class="form-control" required="" name="division_id">
                                <option value="">Select</option>
                                <?php $__currentLoopData = $divisions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $division): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($division->id); ?>"  <?php echo e(($task->division_id == $division->id)? 'selected':''); ?>><?php echo e($division->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group">
                           
                            <input class="form-check-input material-inputs" type="checkbox" id="inlineCheckbox1" value="1" name="to_self"  <?php if($task->to_self == 1){ echo "checked"; } ?>>
                            <label class="form-check-label" for="inlineCheckbox1">To Self</label>
                        </div>
                      
                        <div class="form-group">
                            <label for="username">Priority</label>
                            <!--<input type="text" name="priority" class="form-control" name="priority" value="">-->
                            <select class="form-control" name="priority">
                                <option value="Low" <?php echo e(($task->priority == 'Low')? 'selected':''); ?>>Low</option>
                                <option value="Medium" <?php echo e(($task->priority == 'Medium')? 'selected':''); ?>>Medium</option>
                                <option value="High" <?php echo e(($task->priority == 'High')? 'selected':''); ?>>High</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="username">Descripton</label>
                            <textarea class="form-control" name="description"><?php echo e($task->description); ?></textarea>
                        </div>
                        <div class="form-group">
                            <label for="attachment">Attachment</label>
                            <input type="file" name="attachment" class="form-control" value="<?php echo e($task->attachment); ?>">
                        </div>
                        <div class="form-group">
                            <label for="username">Company</label>
                            <select class="form-control" required="" name="company_id" id="company_id">
                                <option value="">Select</option>
                                <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($company->id); ?>"  <?php echo e(($task->company_id == $company->id)? 'selected':''); ?>><?php echo e($company->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="username">Assigned Staffs</label>
                            <select class="select2 form-control" multiple="multiple" id="staffs" style="height: 36px;width: 100%;" name="staffs[]">
                                <option value="">Select</option>
                                <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($employee->id); ?>" <?php if($user_ids) { if(in_array($employee->id,$user_ids)){ echo "selected"; } } ?> ><?php echo e($employee->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="cc">CC</label>
                            <select class="select2 form-control" id="cc" style="height: 36px;width: 100%;" name="cc">
                                <option value="">Select</option>
                                <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($employee->id); ?>" <?php if($cc) { if($employee->id==$cc){ echo "selected"; } } ?> ><?php echo e($employee->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="username">Status</label>
                            <select class="form-control" required="" name="status">
                                <option value="">Select</option>
                                <!--<option value="1"  <?php if($task->status == 1){ echo "selected"; } ?>>Active</option>-->
                                <!--<option value="0"  <?php if($task->status == 0){ echo "selected"; } ?>>Inactive</option>-->
                                <?php $__currentLoopData = $task_statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task_status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($task_status->id); ?>" <?php echo e(($task->status == $task_status->id)? 'selected':''); ?> ><?php echo e($task_status->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>


                      
                        <div class="modal-footer">

                            <button type="submit" class="btn btn-primary">Save</button>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascripts'); ?>
<script type="text/javascript">
$(function(){
    $('#company_id').on('change',function(){
        var company_id = $(this).val();
        var urlLike = '<?php echo e(url("admin/users/empbycompany")); ?>/'+company_id;
        var staff = $('#staffs');
        $.ajaxSetup({
          headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          }
        });
        $.ajax({
            type: "GET",
            url: urlLike,
            // data: {company_id: company_id},
            success: function(data){
                // console.log(data);
                // $("#staffs").append(html);
                $("#staffs").empty();
                $("#cc").empty();
                $.each(data, function(id,name) {
                    staff.append($('<option>', {value:id, text:name}));
                    $('#cc').append($('<option>', {value:id, text:name}));
                });
            },
            error: function(XMLHttpRequest, textStatus, errorThrown) {
                console.log(XMLHttpRequest);
            }
        });
        
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/devneoli/public_html/tms/resources/views/admin/tasks/edit.blade.php ENDPATH**/ ?>