<?php $__env->startSection('title','Messages'); ?>
<?php $__env->startSection('content'); ?>
<style>
    ul {
        margin: 0;
        padding: 0;
    }
    li {
        list-style:none;
    }
    .user-wrapper, .message-wrapper {
        border: 1px solid #dddddd;
        overflow-y: auto;
    }
    .user-wrapper {
        height:500px;
    }
    .user {
        cursor: pointer;
        padding: 5px 0;
        position: relative;
    }
    .user:hover {
        background: #eeeeee;
    }
    
    .user:last-child {
        margin-bottom: 0;
    }
    
    .pending {
        position: absolute;
        left: 13px;
        top: 9px;
        background: #b600ff;
        margin: 0;
        border-radius: 50%;
        width: 18px;
        height: 18px;
        line-height: 18px;
        padding-left: 7.5px;
        color: #ffffff;
        font-size: 12px;
    }
    .media-left {
        margin: 0 10px;
    }
    .media-left img {
        width: 64px;
        border-radius: 64px;
    }
    .media-body p {
        margin: 6px 0;
    }
    .message-wrapper {
        padding: 10px;
        height: 437px;
        background: #eeeeee;
    }
    .messages .message {
        margin-bottom: 15px;
    }
    .messages .message:last-child {
        margin-bottom: 0;
    }
    .received, .sent {
        width: 45%;
        padding: 3px 10px;
        border-radius: 10px;
    }
    .received {
        background: #ffffff;
    }
    .sent{
        background: #3bebff;
        float: right;
        text-align: right;
    }
    .message p {
        margin: 5px 0;
    }
    .date {
        color: #777777;
        font-size: 12px;
    }
    .active {
        background: #eeeeee;
    }
    input[type=text] {
        width: 100%;
        padding: 12px 20px;
        margin: 15px 0 0 0;
        display: inline-block;
        border-radius: 4px;
        box-sizing: border-box;
        outline: none;
        border: 1px solid #cccccc;
    }
    input[type=text]:focus {
        border: 1px solid #aaaaaa;
    }
</style>
<div class="page-wrapper">
<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">
   <div class="row">
        <div class="col-12">
            <?php echo $__env->make('partials.notifications', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">Messages</h4>
                    <h6 class="card-subtitle"></h6>
                    
                    <div class="row">
                        <div class="col-md-4">
                            <div class="user-wrapper">
                                <ul class="users">
                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="user" id="<?php echo e($user->id); ?>">
                                        <?php if($user->unread): ?>
                                            <span class="pending"></span>
                                            <!-- <span class="pending"></span> -->
                                        <?php endif; ?>
                                        <div class="media">
                                            <div class="media-left">
                                                <img src="https://via.placeholder.com/150" alt="User" class="media-object">
                                            </div>
                                            <div class="media-body">
                                                <p class="name"><?php echo e($user->name); ?></p>
                                                <!-- <p class="position">: </p> -->
                                                <p class="position"><?php echo e($user->email); ?></p>
                                                <p class="position"></p>
                                            </div>
                                        </div>
                                    </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                        <div class="col-md-8" id="messages">
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>
    </div>
    <main class="py-4">
        <?php echo $__env->yieldContent('content'); ?>
    </main>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascripts'); ?>
<script src="https://js.pusher.com/7.0/pusher.min.js"></script>
<script type="text/javascript">

    var receiver_id = "";
    var my_id = "<?php echo e(Auth::id()); ?>";
    $(document).ready(function() {
        
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        
        // Enable pusher logging - don't include this in production
        Pusher.logToConsole = true;
    
        var pusher = new Pusher('12c9aec6f612e5ab552b', {
          cluster: 'ap2'
        });
    
        var channel = pusher.subscribe('my-channel');
        channel.bind('my-event', function (data) {
            // alert(JSON.stringify(data));
            if (my_id == data.from) {
                $('#' + data.to).click();
            } else if (my_id == data.to) {
                if (receiver_id == data.from) {
                    // if receiver is selected, reload the selected user ...
                    $('#' + data.from).click();
                } else {
                    // if receiver is not seleted, add notification for that user
                    var pending = parseInt($('#' + data.from).find('.pending').html());
                    if (pending) {
                        $('#' + data.from).find('.pending').html(pending + 1);
                    } else {
                        $('#' + data.from).append('<span class="pending">1</span>');
                    }
                }
            }
        });
        
        $('.user').click(function() {
            $('.user').removeClass('active');
            $(this).addClass('active');
            $(this).find('.pending').remove();
            receiver_id = $(this).attr('id');
            $.ajax({
                type: "get",
                url: "message/" + receiver_id,
                data: "",
                cache: false,
                success: function(data) {
                    $('#messages').html(data);
                    scrollToBottomFunc();
                }
            });
        });
        
        $(document).on('keyup', '.input-text input', function(e){
            var message = $(this).val();
            if(e.keyCode == 13 && message != '' && receiver_id != '') {
                $(this).val('');
                var datastr = 'receiver_id=' + receiver_id + '&message=' + message;
                $.ajax({
                    type: "post",
                    url: "message",
                    data: datastr,
                    cache: false,
                    success: function(data) {
                    },
                    error: function(jqXHR, status, err, data) {
                    },
                    complete: function() {
                        scrollToBottomFunc();
                    }
                });
            }
        });
    });

    function scrollToBottomFunc() {
        $('.message-wrapper').animate({
            scrollTop: $('.message-wrapper').get(0).scrollHeight
        }, 50);
    }

</script> 
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layout.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\tms\resources\views/admin/messages/index.blade.php ENDPATH**/ ?>