<?php $__env->startSection('title','Users'); ?>
<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
<div class="row page-titles">
    <div class="col-md-5 col-12 align-self-center">
        <h3 class="text-themecolor mb-0">Users</h3>
        <ol class="breadcrumb mb-0 p-0 bg-transparent">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Admin</a></li>
            <li class="breadcrumb-item active">Users</li>
        </ol>
    </div>
   
</div>
<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">
   <div class="row">
        <div class="col-12">
            <?php echo $__env->make('partials.notifications', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">Users</h4>
                    <h6 class="card-subtitle"></h6>
                    <button type="button" class="btn btn-info btn-rounded m-t-10 mb-2 float-right"
                        data-toggle="modal" data-target="#myModal">Add New User</button>
                       <!-- Signup modal content -->
                     
                    <div id="myModal" class="modal fade" tabindex="-1" role="dialog"
                        aria-hidden="true">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content">
                                <div class="modal-body">
                                    <div class="text-center mt-2 mb-4">
                                        <h4 class="modal-title" id="myModalLabel">Add User</h4>
                                    </div>
                                    <?php echo $__env->make('partials.notifications', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <form class="pl-3 pr-3" action="<?php echo e(url('admin/users/add')); ?>" method="post">
                                     <?php echo csrf_field(); ?>

                                        <div class="form-group">
                                            <label for="username">Name</label>
                                            <input class="form-control" type="text" name="name"
                                                required="" placeholder="Name" pattern="[a-zA-Z\s]*" value="<?php echo e(old('name')); ?>">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Username</label>
                                            <input class="form-control" type="text" name="username"
                                                required="" placeholder="Username" pattern="[a-zA-Z]*" value="<?php echo e(old('username')); ?>">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Email</label>
                                            <input class="form-control" type="email" name="email" 
                                                required="" placeholder="Email"  value="<?php echo e(old('email')); ?>">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">User Type</label>
                                            <select class="form-control" required="" name="user_type_id">
                                                <option value="">Select</option>
                                                <?php $__currentLoopData = $user_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($user_type->id); ?>"  <?php echo e((old('user_type_id') == $user_type->id)? 'selected':''); ?>><?php echo e($user_type->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Password</label>
                                            <input class="form-control" type="password" name="password" 
                                                required="" placeholder="Password" minlength="5" title="please enter password with min 5 letters">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Conform Password</label>
                                            <input class="form-control" type="password" name="confirm_password" 
                                                required="" placeholder="confirm Password" minlength="5" title="please enter password with min 5 letters">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Telephone</label>
                                            <input class="form-control" type="text" name="telephone" minlength="8" maxlength="15" 
                                                placeholder="Telephone"  value="<?php echo e(old('telephone')); ?>" onkeypress='return isNumberKey(event);'>
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Mobile Phone</label>
                                            <input class="form-control" type="text" name="mobile" minlength="8" maxlength="15" 
                                                placeholder="Mobile Phone"  value="<?php echo e(old('mobile')); ?>" onkeypress='return isNumberKey(event);'>
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Extension</label>
                                            <input class="form-control" type="text" name="extension" 
                                                placeholder="Extension"  value="<?php echo e(old('extension')); ?>">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Address</label>
                                            <input class="form-control" type="text" name="address" 
                                                placeholder="Extension"  value="<?php echo e(old('address')); ?>">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Date of Join</label>
                                            <input class="form-control" type="date" name="date_of_join" 
                                                placeholder="Date of Join"  value="<?php echo e(old('date_of_join')); ?>">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Designation</label>
                                            <select class="form-control" name="designation_id" required="">
                                                <option value="">Select</option>
                                                <?php $__currentLoopData = $designations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $designation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($designation->id); ?>"  <?php echo e((old('designation_id') == $designation->id)? 'selected':''); ?>><?php echo e($designation->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                         <div class="form-group">
                                            <label for="username">Company</label>
                                            <select class="form-control" name="company_id" required="">
                                                <option value="">Select</option>
                                                <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($company->id); ?>"  <?php echo e((old('company_id') == $company->id)? 'selected':''); ?>><?php echo e($company->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Division</label>
                                            <select class="form-control" name="division_id">
                                                <option value="">Select</option>
                                                <?php $__currentLoopData = $divisions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $division): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($division->id); ?>"  <?php echo e((old('division_id') == $division->id)? 'selected':''); ?>><?php echo e($division->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>

                                        <div class="form-group">
                                            <label for="username">Status</label>
                                            <select class="form-control"  name="status" required="">
                                                <option value="">Select</option>
                                                <option value="1" <?php echo e((old('status')== 1)? 'selected':''); ?>>Active</option>
                                                <option value="0" <?php echo e((old('status')== 0)? 'selected':''); ?>>Inactive</option>
                                            </select>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-light"
                                                data-dismiss="modal">Close</button>
                                            <button type="submit" class="btn btn-primary">Save</button>
                                        </div>

                                    </form>

                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->
                    <div class="row">
                     
                        <select id="second" class="form-control" style="width:40% !important;">
                            <option value="">Select User Type</option>
                            <?php $__currentLoopData = $user_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($user_type->name); ?>"><?php echo e($user_type->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        &emsp;
                        <select id="first" class="form-control" style="width:40% !important;">
                            <option value="">Select Company</option>
                            <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($company->name); ?>"><?php echo e($company->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                      
                    </div>
                        
                    <div class="table-responsive">
                        <table id="default_order"
                            class="table table-bordered m-t-30 table-hover contact-list" data-paging="true"
                            data-paging-size="7">
                            <thead>
                                <tr>
          
                                    <th>Name</th>
                                    <th>User Type</th>
                                    <th id="example">Company</th>
                                    <th>Last Active</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($user->name); ?></td>
                                    <td><?php echo e($user->user_types['name']); ?></td>
                                    <td><?php echo e($user->companies['name']); ?></td>
                                    <td>

                                            <?php if(Cache::has('user-is-online-' . $user->id)): ?>
                                               <b style="color:#4cc125;">Online</b>
                                            <?php else: ?>
                                                <?php echo e(date('d M Y',strtotime($user->updated_at))); ?>

                                            <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($user->status == 1): ?>
                                        <span class="badge badge-success">Active</span>
                                        <?php else: ?>
                                        <span class="badge badge-danger">Inactive</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                    
                                    <a class="edit" title="Edit" style="cursor:pointer;" data-id="<?php echo e($user->id); ?>"> <i class="fas fa-pencil-alt text-inverse m-r-10"></i> </a>
                                        <a href="<?php echo e(URL::to('admin/users/' . $user->id . '/delete')); ?>" onclick="return confirm('Do you want to delete this user?')" title="Delete"> <i class="fas fa-window-close text-danger"></i> </a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <?php echo e($users->render()); ?>

                </div>

            </div>
        </div>
    </div>
</div>
<!-- Signup modal content -->
<div id="editmodal" class="modal fade" tabindex="-1" role="dialog"
    aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
           <div class="text-center mt-2 mb-4">
                <h4 class="modal-title" id="myModalLabel">Edit User</h4>
            </div>
            <div class="modal-body load_view" id="load_view">
               
            </div>
           
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('styles'); ?>
<style src="https://cdn.datatables.net/1.10.23/css/jquery.dataTables.min.css"></style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript_links'); ?>
<script src="https://code.jquery.com/jquery-3.5.1.js"></script>
<script type="https://cdn.datatables.net/1.10.23/js/jquery.dataTables.min.js"></script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascripts'); ?>
<script type="text/javascript">
$(function(){
    $('.edit').on('click',function(){
        id = $(this).data('id');       
        $('.load_view').load('<?php echo e(URL::to("admin/users/")); ?>/'+id+'/edit');
        $('#editmodal').modal('show');
    });
})
function isNumberKey(evt) {
    var charCode = (evt.which) ? evt.which : event.keyCode;
    console.log(charCode);
    if (charCode != 43 &&  charCode > 31
        && (charCode < 48 || charCode > 57))
        return false;

    return true;
}
var table = table =  $('#default_order').DataTable( {});
$('#first').on('change', function () {
        table.columns(2).search( this.value).draw();
} );

$('#second').on('change', function () {
        table.columns(1).search( this.value).draw();
} );



</script> 
<!-- <script type="text/javascript">
<?php if(count($errors) > 0): ?>
    $('#myModal').modal('show');
<?php endif; ?>
</script> -->

<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layout.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/devneoli/public_html/tms/resources/views/admin/users/index.blade.php ENDPATH**/ ?>