@extends('manager.layout.default')
@section('title','Dashboard')
@section('content')
<div class="page-wrapper">
<div class="row page-titles">
    <div class="col-md-5 col-12 align-self-center">
        <h3 class="text-themecolor mb-0">Dashboard</h3>
        <ol class="breadcrumb mb-0">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Home</a></li>
            <li class="breadcrumb-item active">Dashboard</li>
        </ol>
    </div>
    <!--<div class="col-md-7 col-12 align-self-center d-none d-md-block">-->
    <!--    <div class="d-flex mt-2 justify-content-end">-->
    <!--        <div class="d-flex mr-3 ml-2">-->
    <!--            <div class="chart-text mr-2">-->
    <!--                <h6 class="mb-0"><small>THIS MONTH</small></h6>-->
    <!--                <h4 class="mt-0 text-info">$58,356</h4>-->
    <!--            </div>-->
    <!--            <div class="spark-chart">-->
    <!--                <div id="monthchart"></div>-->
    <!--            </div>-->
    <!--        </div>-->
    <!--        <div class="d-flex ml-2">-->
    <!--            <div class="chart-text mr-2">-->
    <!--                <h6 class="mb-0"><small>LAST MONTH</small></h6>-->
    <!--                <h4 class="mt-0 text-primary">$48,356</h4>-->
    <!--            </div>-->
    <!--            <div class="spark-chart">-->
    <!--                <div id="lastmonthchart"></div>-->
    <!--            </div>-->
    <!--        </div>-->
    <!--    </div>-->
    <!--</div>-->
</div>
<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
 <div class="container-fluid">
    <!-- Row -->
    <div class="row">
        <!-- Column -->
        <div class="col-lg-3 col-md-6">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex flex-row">
                        <div
                            class="round round-lg text-white d-inline-block text-center rounded-circle bg-info">
                            <i class="ti-user"></i>
                        </div>
                        <a href="{{ url('manager/users') }}">
                        <div class="ml-2 align-self-center">
                            <h3 class="mb-0 font-weight-light">{{ count($users) }}</h3>
                            <h5 class="text-muted mb-0">Total Users</h5>
                        </div>
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <!-- Column -->
        <!-- Column -->
        <div class="col-lg-3 col-md-6">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex flex-row">
                        <div
                            class="round round-lg text-white d-inline-block text-center rounded-circle bg-warning">
                            <i class="mdi mdi-cellphone-link"></i></div>
                        <a href="{{ url('manager/tasks') }}">
                        <div class="ml-2 align-self-center">
                            <h3 class="mb-0 font-weight-light">{{ count($tasks) }}</h3>
                            <h5 class="text-muted mb-0">Total Tasks</h5>
                        </div>
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <!-- Column -->
        <!-- Column -->
        <div class="col-lg-3 col-md-6">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex flex-row">
                        <div
                            class="round round-lg text-white d-inline-block text-center rounded-circle bg-primary">
                            <i class="mdi mdi-clipboard-outline"></i></div>
                        <a href="{{ url('manager/tasks') }}">
                        <div class="ml-2 align-self-center">
                            <h3 class="mb-0 font-weight-light">{{ count($tasks->whereNotIn('status',8)) }}</h3>
                            <h5 class="text-muted mb-0">Pending Tasks</h5>
                        </div>
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <!-- Column -->
        <!-- Column -->
        <div class="col-lg-3 col-md-6">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex flex-row">
                        <div
                            class="round round-lg text-white d-inline-block text-center rounded-circle bg-success">
                            <i class="mdi mdi-clipboard-outline"></i></div>
                        <a href="{{ url('manager/tasks') }}">
                        <div class="ml-2 align-self-center">
                            <h3 class="mb-0 font-weight-light">{{ count($recent_tasks) }}</h3>
                            <h5 class="text-muted mb-0">Recent Tasks</h5>
                        </div>
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <!-- Column -->
        
    </div>
    
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-md-flex no-block">
                        <h4 class="card-title">Recent Tasks</h4>
                    </div>
                    <div class="month-table">
                        <div class="table-responsive mt-3">
                            <table class="table stylish-table v-middle mb-0 no-wrap">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Name</th>
                                    <th>Updated at</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                            @foreach($tasks as $task)
                                <tr>
                                    <td>{{ $task->task_id }}</td>
                                    <td>{{ $task->name }}</td>
                                    <td>{{ date('d M Y',strtotime($task->updated_at)) }}</td>
                                     <td>
                                        <span class="badge" style="background-color:{{$task->task_status['color']}}; color:#ffffff; width:87px;">
                                            {{ $task->task_status['name'] }}
                                        </span>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <div class="col-lg-4">
        </div>
          
            </div>
    
</div>
</div>
@endsection

