<style>
    ul {
        margin: 0;
        padding: 0;
    }
    li {
        list-style:none;
    }
    .user-wrapper, .message-wrapper {
        border: 1px solid #dddddd;
        overflow-y: auto;
    }
    .user-wrapper {
        height:500px;
    }
    .user {
        cursor: pointer;
        padding: 5px 0;
        position: relative;
    }
    .user:hover {
        background: #eeeeee;
    }
    
    .user:last-child {
        margin-bottom: 0;
    }
    
    .pending {
        position: absolute;
        left: 13px;
        top: 9px;
        background: #b600ff;
        margin: 0;
        border-radius: 50%;
        width: 18px;
        height: 18px;
        line-height: 18px;
        padding-left: 7.5px;
        color: #ffffff;
        font-size: 12px;
    }
    .media-left {
        margin: 0 10px;
    }
    .media-left img {
        width: 64px;
        border-radius: 64px;
    }
    .media-body p {
        margin: 6px 0;
    }
    .message-wrapper {
        padding: 10px;
        height: 300px;
        background: #eeeeee;
    }
    .messages .message {
        margin-bottom: 15px;
    }
    .messages .message:last-child {
        margin-bottom: 0;
    }
    .received, .sent {
        width: 45%;
        padding: 3px 10px;
        border-radius: 10px;
    }
    .received {
        background: #ffffff;
    }
    .sent{
        background: #3bebff;
        float: right;
        text-align: right;
    }
    .message p {
        margin: 5px 0;
    }
    .date {
        color: #777777;
        font-size: 12px;
    }
    .active {
        background: #eeeeee;
    }
    input[type=text] {
        width: 100%;
        padding: 12px 20px;
        margin: 15px 0 0 0;
        display: inline-block;
        border-radius: 4px;
        box-sizing: border-box;
        outline: none;
        border: 1px solid #cccccc;
    }
    input[type=text]:focus {
        border: 1px solid #aaaaaa;
    }
    
    .slider {
      -webkit-appearance: none;
      width: 100%;
      height: 25px;
      background: #d3d3d3;
      outline: none;
      opacity: 0.7;
      -webkit-transition: .2s;
      transition: opacity .2s;
    }
    
    .slider:hover {
      opacity: 1;
    }
    
    .slider::-webkit-slider-thumb {
      -webkit-appearance: none;
      appearance: none;
      width: 25px;
      height: 25px;
      background: #4CAF50;
      cursor: pointer;
    }
    
    .slider::-moz-range-thumb {
      width: 25px;
      height: 25px;
      background: #4CAF50;
      cursor: pointer;
    }
</style>

<form class="pl-3 pr-3" method="post" action="{{ url('employee/taskhistory/add') }}">
{!! csrf_field() !!}
<div class="row">
    <div class="col-md-2">
        History
    </div>
    <div class="col-md-10">
        <div class="form-group">
            <label for="creater">Created By</label>
            <span class="pl-3">{{ $task->owner['name'] }}</span>
            <label class="pl-3" for="date">On</label>
            <span class="pl-3">{{ $task->created_at }}</span>
        </div>
        @foreach($history as $histories)
        <div class="form-group">
            Task Transfered from {{ $histories->from_user['name'] }} to {{ $histories->to_user['name'] }} on {{ $histories->created_at }}
        </div>
        @endforeach
    </div>
    <div class="col-md-2">
        <label for="transfer_to">Transfer to</label>
    </div>
    <div class="col-md-10">
        <div class="form-group">
            <input type="hidden" value="{{ $task->id }}" name="transfer_task_id">
            <input type="hidden" value="{{ $task->owner['id'] }}" name="transfer_created_by">
            <input type="hidden" value="{{ $task->users }}" class="task_users">
            <!--<label for="company">Company</label>-->
            <!--<select name="transfer_company" class="form-control">-->
            <!--    <option value="" disabled selected>Select Company</option>-->
            <!--    @foreach($companies as $company)-->
            <!--        <option value="{{ $company->id }}">{{ $company->name }}</option>-->
            <!--    @endforeach-->
            <!--</select>-->
            <select name="transfer_to" class="form-control" required>
                <option value="" disabled selected>Select Employee</option>
                @foreach($employees as $employee)
                    <option value="{{ $employee->id }}">{{ $employee->name }}</option>
                @endforeach
            </select>
        </div>
    </div>
</div>

<div class="modal-footer">
    <button type="button" class="btn btn-light" data-dismiss="modal">Close</button>
    <button type="submit" class="btn btn-primary">Transfer</button>
</div>
</form>
@section('javascripts')
<!--<script src="https://js.pusher.com/7.0/pusher.min.js"></script>-->
<script type="text/javascript">

    $(document).ready(function() {
        
        $('.user').on('click',function(){
    
        
            // receiver_id = JSON.parse($('#task_users').attr('value'));
            receiver_id = "testimonial";
            // $.ajax({
            //     type: "get",
            //     url: "message/" + receiver_id,
            //     data: "",
            //     cache: false,
            //     success: function(data) {
            //         $('#messages').html(data);
            //         scrollToBottomFunc();
            //     }
            // });
            $('#messages').html("receiver_id");
        });
    
    });

</script> 
@endsection
