<?php namespace App\Http\Controllers;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Session;
use Redirect;
use Auth;
use DB;
use Mail;
use \App\User;
use Hash;
use URL;
use \App\UserType;
use Carbon\Carbon;


class UsersController extends Controller {
    
    
    /* Function to get Login page
    *  18-01-2021
    */
    public function getLogin(){
       return view('auth/login');
    
    }


    /* Function to do Login
    *  18-01-2021
    */
    public function doLogin(Request $req){


        $request =  $req->input();
       
        
        if ($request)
        {

            $remember = $req->input('remember');
            $fieldType = filter_var($req->input('email'), FILTER_VALIDATE_EMAIL) ? 'email' : 'username';
            $userdata = array(
                $fieldType     => $req->input('email'),
                // 'email'     => $req->input('email'),
                'password'  => $req->input('password')
            );
         
            if(Auth::attempt($userdata,$remember))
            {
                $user = Auth::user();
                $this->updateLastLogin(Auth::id());
                if($user->user_type_id == 1 && $user->status == 1){
                    return redirect()->intended('admin');
                }else if($user->user_type_id == 2 && $user->status == 1){
                    return redirect()->intended('manager');   
                }else if($user->user_type_id == 3 && $user->status == 1){
                    return redirect()->intended('employee');   
                }else
                {
                    Auth::logout();
                    return Redirect::back()->with('error', 'Incorrect Username or Password.');
                }
                  
            }
            else
            {
                Auth::logout();
                return Redirect::back()->with('error', 'Incorrect Username or Password.');
            }
        }       
    }

      
    public function updateLastLogin($user_id){
        $user = \App\User::findOrFail($user_id);
        $user->last_login= date('Y-m-d H:i:s');
        $user->save();
        return $user->id;   
    }


    /* Function to get Logout
    *  18-01-2021
    */
    public function getLogout(){
        Auth::logout();
        return Redirect::to('/');
    }

   
    /* Function to get admin dashboard
    *  18-01-2021
    */
    public function getAdminDashboard()
    {
        if(Auth::user())
        {
            $user = Auth::user();
            $users = \App\User::get();
            $tasks = \App\Task::get();
            $companies = \App\Company::get();
            $reminders = \App\Reminder::get();
            $recent_tasks = \App\Task::whereDate('created_at', '>', Carbon::now()->subDays(2))->get();

            return view('admin.home.dashboard',['user'=>$user,'users'=>$users,'tasks'=>$tasks,'companies'=>$companies,'reminders'=>$reminders, 'recent_tasks'=>$recent_tasks]);
        }
        else
        {
            return Redirect::to('/');
        }
    }

    /* Function to get manager dashboard
    *  18-01-2021
    */
    public function getManagerDashboard()
    {
        if(Auth::user())
        {
            $user = Auth::user();
            $company_id = \App\User::where('id',Auth::id())->pluck('company_id')->first();
            $users = \App\User::where('company_id', $company_id)->where('user_type_id',3)->get();
            $tasks = \App\Task::where('company_id',$company_id)->get();
            $recent_tasks = \App\Task::where('company_id',$company_id)->whereDate('created_at', '>', Carbon::now()->subDays(2))->get();
            // print_r($company_id);die();
            return view('manager.home.dashboard',['user'=>$user, 'users'=>$users, 'tasks'=>$tasks, 'recent_tasks'=>$recent_tasks]);
        }
        else
        {
            return Redirect::to('/');
        }
    }


    /* Function to get employee dashboard
    *  18-01-2021
    */
    public function getEmployeeDashboard()
    {
        if(Auth::user())
        {
            $user = Auth::user();
            $users = \App\User::get();
            // $tasks = \App\Task::paginate(5);
            $tasks = \App\Task::whereJsonContains('users',["".Auth::id().""])->get();
            $recent_tasks = \App\Task::whereJsonContains('users',["".Auth::id().""])->whereDate('created_at', '>', Carbon::now()->subDays(2))->get();
            return view('employee.home.dashboard',['user'=>$user, 'tasks'=>$tasks, 'recent_tasks'=>$recent_tasks]);
        }
        else
        {
            return Redirect::to('/');
        }
    }

    /*
    * To load forgot password link
    * 19-01-2021
    */
    public function forgotPassword(Request $req){
        $input =  $req->input();
        if(!empty($input)){
            $email = $req->input('email');
            $user =  \App\User::where('email',$email)->first(); 

            if(!empty($user)){

                $user_data = \App\User::select('last_login')->where('id',$user->id)->first();
             
                $key = md5($user_data->last_login);

                if($user->user_type_id == 1){
                    Mail::send(['email.html.auth.forgot_password', 'email.text.auth.forgot_password'] , ['user' => $user, 'key' => $key ,'client' => $client], function ($m) use ($user) {
                        $m->to($user->email, $user->name)->subject('TMS Password Reset');
                    });
                   
                }
                else if($user->user_type_id == 2){
                    Mail::send(['email.html.auth.forgot_password', 'email.text.auth.forgot_password'] , ['user' => $user, 'key' => $key], function ($m) use ($user) {
                        $m->to($user->email, $user->name)->subject('TMS Password Reset');
                    });
                 
                }
                else if($user->user_type_id == 3){
                    Mail::send(['email.html.auth.forgot_password', 'email.text.auth.forgot_password'] , ['user' => $user, 'key' => $key], function ($m) use ($user) {
                        $m->to($user->email, $user->name)->subject('TMS Password Reset');
                    });
                 
                }
                return Redirect::back()->with('success', 'Check your email and follow the instructions.');
            }else{
                return Redirect::back()->with('error', 'No matching email id found.');
            }
        }
        return view('admin/auth/login');
    }

    /*
    * To reset the password through email
    * 20-01-2021
    */
    public function resetPassword($user_id,$key){
        if(!empty($key)){
            $user_data = \App\User::select('last_login')->where('id',$user_id)->first();
            if(!empty($user_data)){
                if($key == md5($user_data->last_login)){
                    return view('frontend/auth/reset_password', ['user_id' => $user_id, 'key' => $key]);
                }else{
                    return Redirect::to('forgotpassword')->with('error', 'Password reset link expired.');
                } 
            }else{
                return Redirect::to('forgotpassword')->with('error', 'Password reset link expired.');
            }
        }else{
            return Redirect::to('forgotpassword')->with('error', 'Password reset link expired or user not exist.');
        }
    }
    /*
    * To post reset password
    * 20-01-2021
    */
    public function postResetPassword(){
        $id = Request::get('user_id');
        $user   = User::findOrFail($id);
        $input  =  $req->input();
        if(!empty($input)){
            $validate = Validator::make(Request::all(), [
                'password'              => 'required|max:15|min:6',
                'confirm_password'      => 'required|max:15|min:6',
            ]);
            if (!$validate->fails()){
                $password           = Request::get('password');
                $c_password         = Request::get('confirm_password');
                if($password == $c_password){
                    $new_password   = Hash::make($password);
                    $userdata = array(
                        'password'  => Request::get('old_password')
                    );
                    DB::table('users')->where('id',$user->id)->update(
                        array(
                            'password' => $new_password
                        )
                    );
                    \App\ActivityLog::log("Password changed (email request) for user.", array('affected_id' => $user->id, "updated_user" => $user->id));
                    return Redirect::to('login')->with('success', 'Password Changed Successfully. Please login using the new password.');
                    
                }else{
                    return Redirect::back()->with('error', 'The New Password field does not match the Confirm Password field');
                }
            }else{
                return Redirect::back()->with('error', 'Password must be 6-15 characters');
            }
        }
    }

    public function getUsers(){

        $users = \App\User::where('user_type_id','<>',1)->paginate(15);
        $designations = \App\Designation::get();
        $companies = \App\Company::get();
        $user_types = \App\UserType::get();
        $divisions = \App\Division::get();

        return view('admin.users.index',['users'=>$users,'designations'=>$designations,'companies'=>$companies,'user_types'=>$user_types,'divisions'=>$divisions]);

    }

    public function getManagerUsers(){

        $company_id = \App\User::where('id',Auth::id())->pluck('company_id')->first();
        // $users = \App\User::where('user_type_id',3)->where('add_user',Auth::id())->paginate(15);
        $users = \App\User::where('company_id',$company_id)->where('user_type_id',3)->paginate(15);
        $designations = \App\Designation::get();
        $companies = \App\Company::get();
        $user_types = \App\UserType::get();

        $divisions = \App\Division::get();

        return view('manager.users.index',['users'=>$users,'designations'=>$designations,'companies'=>$companies,'user_types'=>$user_types,'divisions'=>$divisions]);

    }

  



    /* To delete users
    *  21-01-2021
    */
    public function userDelete($id){
        if(!empty($id)){
            $user = \App\User::findOrFail($id);
            if($user){
                \App\User::destroy($id);
                return Redirect::to('admin/users')->with('success', 'User deleted successfully!');
            }
        }else{
            return Redirect::to('admin/users')->with('error', 'You cannot delete!');
        }
    }

     /* To delete users
    *  21-01-2021
    */
    public function userManagerDelete($id){
        if(!empty($id)){
            $user = \App\User::findOrFail($id);
            if($user){
                \App\User::destroy($id);
                return Redirect::to('manager/users')->with('success', 'User deleted successfully!');
            }
        }else{
            return Redirect::to('manager/users')->with('error', 'You cannot delete!');
        }
    }
  
     /* Admin to add users
    *  18-09-2020
    */
    public function addPostUsers(Request $req){

        $rules = array(
                'email'             => 'required|email|unique:users',
                'password'          => 'required|min:5',
                'confirm_password'  => 'same:password',
        );

        $validator = \Validator::make($req->input(), $rules);
        if (!$validator->fails())
        {
            $user                 = new \App\User;
            $user->name           = $req->input('name');
            $user->add_user       = Auth::id();
            $user->email          = $req->input('email');
            $user->username       = $req->input('username');
            $user->password       = $req->input('password');
            $user->telephone      = $req->input('telephone');
            $user->mobile         = $req->input('mobile');
            $user->extension      = $req->input('extension');
            $user->address        = $req->input('address');
            $user->date_of_join   = $req->input('date_of_join');
            $user->designation_id = $req->input('designation_id');
            $user->division_id    = $req->input('division_id');
            $user->company_id     = $req->input('company_id');
            $user->user_type_id   = $req->input('user_type_id');

         
            $user->status         = $req->input('status');
            $user->save();

             
            return Redirect::to('admin/users')->with('success', 'User added successfully!');
        }else{
            return Redirect::back()->withErrors($validator)->withInput();

        }
        
    }


     /* Admin to add users
    *  18-09-2020
    */
    public function addPostManagerUsers(Request $req){

        $rules = array(
                'email'             => 'required|email|unique:users',
                'password'          => 'required|min:5',
                'confirm_password'  => 'same:password',
        );

        $validator = \Validator::make($req->input(), $rules);
        if (!$validator->fails())
        {
            $user                 = new \App\User;
            $user->name           = $req->input('name');
            $user->add_user       = Auth::id();
            $user->email          = $req->input('email');
            $user->username       = $req->input('username');
            $user->password       = $req->input('password');
            $user->telephone      = $req->input('telephone');
            $user->mobile         = $req->input('mobile');
            $user->extension      = $req->input('extension');
            $user->address        = $req->input('address');
            $user->date_of_join   = $req->input('date_of_join');
            $user->designation_id = $req->input('designation_id');
            $user->division_id    = $req->input('division_id');
            $user->company_id     = $req->input('company_id');
            $user->user_type_id   = $req->input('user_type_id');

         
            $user->status         = $req->input('status');
            $user->save();

             
            return Redirect::to('manager/users')->with('success', 'User added successfully!');
        }else{
            return Redirect::back()->withErrors($validator)->withInput();

        }
        
    }


    /* Admin to edit users
    *  23-01-2021
    */
    public function editUsers(Request $req,$id){


        $user  = \App\User::where('id',$id)
                ->first();

        $designations = \App\Designation::get();
        $companies = \App\Company::get();

        $user_types = \App\UserType::get();

        $divisions = \App\Division::get();

      
        return view('admin.users.edit',['user' => $user,'designations'=>$designations,'companies'=>$companies,'user_types'=>$user_types,'divisions'=>$divisions]);
    }
     
    public function editManagerUsers(Request $req,$id){


        $user  = \App\User::where('id',$id)
                ->first();

        $designations = \App\Designation::get();
        $companies = \App\Company::get();

        $user_types = \App\UserType::get();

        $divisions = \App\Division::get();

      
        return view('manager.users.edit',['user' => $user,'designations'=>$designations,'companies'=>$companies,'user_types'=>$user_types,'divisions'=>$divisions]);
    }
    /* Admin to add users
    *  23-01-2021
    */
    public function editPostUsers(Request $req){

        $id = $req->input('id');

        $rules = array(
                'email'             => 'required|email|unique:users,email,'.$id,
                'password'          => 'required|min:5',
                'confirm_password'  => 'same:password',
        );

        $validator = \Validator::make($req->input(), $rules);
        if (!$validator->fails())
        {
    
            $user                 = \App\User::findOrFail($id);
            $user->name           = $req->input('name');
            $user->email          = $req->input('email');
            $user->username       = $req->input('username');
            $user->password       = $req->input('password');
            $user->telephone      = $req->input('telephone');
            $user->mobile         = $req->input('mobile');
            $user->extension      = $req->input('extension');
            $user->address        = $req->input('address');                 
            $user->date_of_join   = $req->input('date_of_join');
            $user->designation_id = $req->input('designation_id');
            $user->division_id    = $req->input('division_id');
            $user->company_id     = $req->input('company_id');
            $user->user_type_id   = $req->input('user_type_id');
         
            $user->status         = $req->input('status');
            $user->save();
            return Redirect::to('admin/users')->with('success', 'User updated successfully!');
        }else{
            return Redirect::back()->withErrors($validator)->withInput();
        }

    
   

        
    }

      public function editPostManagerUsers(Request $req){

        $id = $req->input('id');

        $rules = array(
                'email'             => 'required|email|unique:users,email,'.$id,
                'password'          => 'required|min:5',
                'confirm_password'  => 'same:password',
        );

        $validator = \Validator::make($req->input(), $rules);
        if (!$validator->fails())
        {
    
            $user                 = \App\User::findOrFail($id);
            $user->name           = $req->input('name');
            $user->email          = $req->input('email');
            $user->username       = $req->input('username');
            $user->password       = $req->input('password');
            $user->telephone      = $req->input('telephone');
            $user->mobile         = $req->input('mobile');
            $user->extension      = $req->input('extension');
            $user->address        = $req->input('address');                 
            $user->date_of_join   = $req->input('date_of_join');
            $user->designation_id = $req->input('designation_id');
            $user->company_id     = $req->input('company_id');
            $user->division_id    = $req->input('division_id');
            $user->user_type_id   = $req->input('user_type_id');
         
            $user->status         = $req->input('status');
            $user->save();
            return Redirect::to('manager/users')->with('success', 'User updated successfully!');
        }else{
            return Redirect::back()->withErrors($validator)->withInput();
        }

    
   

        
    }

    public function adminprofile(){


        $user  = Auth::user();

        $designations = \App\Designation::get();
        $companies = \App\Company::get();

        $user_types = \App\UserType::get();

      
        return view('admin.home.profile',['user' => $user,'designations'=>$designations,'companies'=>$companies,'user_types'=>$user_types]);

    }
    
    public function managerprofile(){


        $user  = Auth::user();

        $designations = \App\Designation::get();
        $companies = \App\Company::get();

        $user_types = \App\UserType::get();

      
        return view('manager.home.profile',['user' => $user,'designations'=>$designations,'companies'=>$companies,'user_types'=>$user_types]);

    }
    
    public function employeeprofile(){


        $user  = Auth::user();

        $designations = \App\Designation::get();
        $companies = \App\Company::get();

        $user_types = \App\UserType::get();

      
        return view('employee.home.profile',['user' => $user,'designations'=>$designations,'companies'=>$companies,'user_types'=>$user_types]);

    }


    public function admineditprofile(Request $req){

        $id = $req->input('id');
        $user                = \App\User::findOrFail($id);
        $user->name           = $req->input('name');
        $user->telephone      = $req->input('telephone');
        $user->mobile         = $req->input('mobile');
        $user->address        = $req->input('address');                 
        $user->save();
        return Redirect::to('admin/profile')->with('success', 'Profile updated successfully!');
    
    }
    
    public function managereditprofile(Request $req){

        $id = $req->input('id');
        $user                = \App\User::findOrFail($id);
        $user->name           = $req->input('name');
        $user->telephone      = $req->input('telephone');
        $user->mobile         = $req->input('mobile');
        $user->address        = $req->input('address');                 
        $user->save();
        return Redirect::to('manager/profile')->with('success', 'Profile updated successfully!');
    
    }
    
    public function employeeeditprofile(Request $req){

        $id = $req->input('id');
        $user                = \App\User::findOrFail($id);
        $user->name           = $req->input('name');
        $user->telephone      = $req->input('telephone');
        $user->mobile         = $req->input('mobile');
        $user->address        = $req->input('address');                 
        $user->save();
        return Redirect::to('employee/profile')->with('success', 'Profile updated successfully!');
    
    }


    public function changepassword(){


        $user  = Auth::user();

        $my_id = Auth::id();
        $user_type = \App\User::where('id',$my_id)->value('user_type_id');
        
        if($user_type==1) {
            return view('admin.home.change_password',['user' => $user]);
        }
        elseif($user_type==2) {
            return view('manager.home.change_password',['user' => $user]);
        }
        elseif($user_type==3) {
            return view('employee.home.change_password',['user' => $user]);
        }
    }


    public function postchangepassword(Request $req){
      
        $user = Auth::user();
        $input  = $req->input();
        if(!empty($input)){
     
            $password           = $req->input('password');
            $c_password         = $req->input('confirm_password');
            $old_password       = $req->input('old_password');
            if($password == $c_password){
                $userdata = array(
                    'email'     => $user->email,
                    'password'  => $old_password
                );
              
                if(Hash::check($password, $user->password)){ 
                    return Redirect::back()->with('error', 'Old and new passwords cannot be same.');     
                }

                if(Auth::attempt($userdata)){
                    $new_password   = Hash::make($password);
                
                    DB::table('users')->where('id',$user->id)->update(
                        array(
                             'password' => $new_password
                            )
                    ); 
              
                    return Redirect::back()->with('success', 'Password Changed Successfully.');
                    
                }else{
                    return Redirect::back()->with('error', 'Incorrect old password.');
                }
                
            }else{
                return Redirect::back()->with('error', 'Password and confirm password should be same.');
            }
           
        }
    
    }
    
    public function getUsersByCompany($company_id){
        // $data  = \App\User::where('company_id',$company_id)->pluck('id', 'name');
        $data  = \App\User::where('company_id',$company_id)->whereNotIn('user_type_id',['1'])->pluck('name','id');
        // return $data;
        return response()->json($data);
    }


  
}
