<?php namespace App\Http\Controllers;
use Illuminate\Support\Faccontactes\Validator;
use Illuminate\Http\Request;
use Pusher\Pusher;
use Session;
use Redirect;
use Auth;
use DB;
class MessagesController extends Controller {


    /* Admin list contacts page
    *  17-03-2020
    */
    public function getMessages(){

        // $users = \App\User::where('id','!=',Auth::id())->get();
        $users = DB::select("select users.id, users.name, users.email, users.company_id, users.designation_id, count(is_read) as unread 
        from users LEFT  JOIN  messages ON users.id = messages.from and is_read = 0 and messages.to = " . Auth::id() . "
        where users.id != ".Auth::id()." 
        group by users.id, users.name, users.email, users.company_id, users.designation_id");
        return view('admin.messages.index',['users'=>$users]);

    }
    
    public function getMessage($user_id){
        $my_id = Auth::id();
        \App\Message::where(['from' => $user_id, 'to' => $my_id])->update(['is_read' => '1']);
        $messages = \App\Message::where(function($query) use ($user_id, $my_id) {
            $query->where('from', $my_id)->where('to', $user_id);
        })->orWhere(function($query) use ($user_id, $my_id) {
            $query->where('from', $user_id)->where('to', $my_id);
        })->get();
        return view('admin.messages.messages', ['messages'=>$messages]);
        
    }
    
    public function sendMessage(Request $request) {
        $from = Auth::id();
        $to = $request->receiver_id;
        $message = $request->message;
        
        $data = new \App\Message;
        $data->from = $from;
        $data->to = $to;
        $data->message = $message;
        $data->is_read = '0';
        $data->save();
        
        $options = array(
            'cluster' => 'ap2',
            'useTLS' => true
        );

        $pusher = new Pusher(
            env('PUSHER_APP_KEY'),
            env('PUSHER_APP_SECRET'),
            env('PUSHER_APP_ID'),
            $options
        );

        $data = ['from' => $from, 'to' => $to]; // sending from and to user id when pressed enter
        $pusher->trigger('my-channel', 'my-event', $data);
    }
    
    public function getManagerMessages(){

        // $users = \App\User::where('id','!=',Auth::id())->get();
        $company_id = \App\User::where('id',Auth::id())->value('company_id');
        $users = DB::select("select users.id, users.name, users.email, users.company_id, users.designation_id, count(is_read) as unread 
        from users LEFT  JOIN  messages ON users.id = messages.from and is_read = 0 and messages.to = " . Auth::id() . "
        where users.id != ".Auth::id()." AND users.company_id = ".$company_id."
        group by users.id, users.name, users.email, users.company_id, users.designation_id");
        return view('manager.messages.index',['users'=>$users]);

    }
    
    public function getManagerMessage($user_id){
        $my_id = Auth::id();
        \App\Message::where(['from' => $user_id, 'to' => $my_id])->update(['is_read' => '1']);
        $messages = \App\Message::where(function($query) use ($user_id, $my_id) {
            $query->where('from', $my_id)->where('to', $user_id);
        })->orWhere(function($query) use ($user_id, $my_id) {
            $query->where('from', $user_id)->where('to', $my_id);
        })->get();
        return view('manager.messages.messages', ['messages'=>$messages]);
        
    }
    
    public function sendManagerMessage(Request $request) {
        $from = Auth::id();
        $to = $request->receiver_id;
        $message = $request->message;
        
        $data = new \App\Message;
        $data->from = $from;
        $data->to = $to;
        $data->message = $message;
        $data->is_read = '0';
        $data->save();
        
        $options = array(
            'cluster' => 'ap2',
            'useTLS' => true
        );

        $pusher = new Pusher(
            env('PUSHER_APP_KEY'),
            env('PUSHER_APP_SECRET'),
            env('PUSHER_APP_ID'),
            $options
        );

        $data = ['from' => $from, 'to' => $to]; // sending from and to user id when pressed enter
        $pusher->trigger('my-channel', 'my-event', $data);
    }
    
    public function getEmployeeMessages(){

        // $users = \App\User::where('id','!=',Auth::id())->get();
        $company_id = \App\User::where('id',Auth::id())->value('company_id');
        $users = DB::select("select users.id, users.name, users.email, users.company_id, users.designation_id, count(is_read) as unread 
        from users LEFT  JOIN  messages ON users.id = messages.from and is_read = 0 and messages.to = " . Auth::id() . "
        where users.id != ".Auth::id()." AND users.company_id = ".$company_id."
        group by users.id, users.name, users.email, users.company_id, users.designation_id");
        return view('employee.messages.index',['users'=>$users]);

    }
    
    public function getEmployeeMessage($user_id){
        $my_id = Auth::id();
        \App\Message::where(['from' => $user_id, 'to' => $my_id])->update(['is_read' => '1']);
        $messages = \App\Message::where(function($query) use ($user_id, $my_id) {
            $query->where('from', $my_id)->where('to', $user_id);
        })->orWhere(function($query) use ($user_id, $my_id) {
            $query->where('from', $user_id)->where('to', $my_id);
        })->get();
        return view('employee.messages.messages', ['messages'=>$messages]);
        
    }
    
    public function sendEmployeeMessage(Request $request) {
        $from = Auth::id();
        $to = $request->receiver_id;
        $message = $request->message;
        
        $data = new \App\Message;
        $data->from = $from;
        $data->to = $to;
        $data->message = $message;
        $data->is_read = '0';
        $data->save();
        
        $options = array(
            'cluster' => 'ap2',
            'useTLS' => true
        );

        $pusher = new Pusher(
            env('PUSHER_APP_KEY'),
            env('PUSHER_APP_SECRET'),
            env('PUSHER_APP_ID'),
            $options
        );

        $data = ['from' => $from, 'to' => $to]; // sending from and to user id when pressed enter
        $pusher->trigger('my-channel', 'my-event', $data);
    }

}
