<?php namespace App\Http\Controllers;
use Illuminate\Support\Faccontactes\Validator;
use Illuminate\Http\Request;
use Session;
use Redirect;
use Auth;
use DB;
class DesignationsController extends Controller {

    /* Admin to add designations
    *  23-01-2021
    */
    public function addDesignations(Request $req){
      
        return view('admin.designations.add');
    }
     
    /* Admin to add designations
    *  23-01-2021
    */
    public function addPostDesignations(Request $req){
        
        $designation                = new \App\Designation;
        $designation->name          = $req->input('name');
        $designation->status        = $req->input('status');
        $designation->save();
        return Redirect::to('admin/designations')->with('success', 'Designation added successfully!');
      

        
    }

    /* Admin to edit designations
    *  23-01-2021
    */
    public function editDesignations(Request $req,$id){


        $designation  = \App\Designation::where('id',$id)
                ->first();

      
        return view('admin.designations.edit',['designation' => $designation]);
    }
     
    /* Admin to add designations
    *  23-01-2021
    */
    public function editPostDesignations(Request $req){

        $id = $req->input('id');
    
        $designation                = \App\Designation::findOrFail($id);
        $designation->name          = $req->input('name');
        $designation->status        = $req->input('status');
        $designation->save();
        return Redirect::to('admin/designations')->with('success', 'Designation updated successfully!');
   

        
    }

    /* Admin list contacts page
    *  17-03-2020
    */
    public function getDesignations(){

        $designations = \App\Designation::paginate(15);
        return view('admin.designations.index',['designations'=>$designations]);

    }

    /* Admin view contact details
    *  13-03-2019
    */
    public function designationView(Request $req,$id){
    
        $designation  = \App\Designation::where('id',$id)
             ->first();
        return view('admin.designations.view',['designation'=>$designation]);
    
    }

    /* To delete contact
    *  13-03-2020
    */
    public function DesignationsDelete($id){
        if(!empty($id)){
            $designation = \App\Designation::findOrFail($id);
            if($designation){
                \App\Designation::destroy($id);
                return Redirect::to('admin/designations')->with('success', 'Designation deleted successfully!');
            }
        }else{
            return Redirect::to('admin/designations')->with('error', 'You cannot delete!');
        }
    }

    /*Admin change status of designations
    * 23-01-2021
    */
    public function changeStatus(Request $req){

        $id             = $req->input('id');
        $status         = $req->input('status');
       
        $data           = $req->input('data');
        $designation  = \App\Designation::findOrFail($id);
        if($designation){

            if($data == 1){
                
                $designation->status = $status;

            }else{
                
                if($status == 1){
                
                    $designation->status = 0;
                
                }else{
                
                    $designation->status = 1;
                
                }   
            
            }
            
            $designation->save();
            return Redirect::back()->with('success', 'Status changed successfully.');

        }
    }
   


}
