<?php $__env->startSection('title','Users'); ?>
<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
<div class="row page-titles">
    <div class="col-md-5 col-12 align-self-center">
        <h3 class="text-themecolor mb-0">Users</h3>
        <ol class="breadcrumb mb-0 p-0 bg-transparent">
           <!--  <li class="breadcrumb-item"><a href="javascript:void(0)">Admin</a></li> -->
            <li class="breadcrumb-item active">Users</li>
        </ol>
    </div>
   
</div>
<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">
   <div class="row">
        <div class="col-12">
            <?php echo $__env->make('partials.notifications', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">Users</h4>
                    <h6 class="card-subtitle"></h6>
                    <button type="button" class="btn btn-info btn-rounded m-t-10 mb-2 float-right"
                        data-toggle="modal" data-target="#myModal">Add New User</button>
                       <!-- Signup modal content -->
                    <div id="myModal" class="modal fade" tabindex="-1" role="dialog"
                        aria-hidden="true">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content">
                                <div class="modal-body">
                                    <div class="text-center mt-2 mb-4">
                                        <h4 class="modal-title" id="myModalLabel">Add User</h4>
                                    </div>
                                    <?php echo $__env->make('partials.notifications', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <form class="pl-3 pr-3" action="<?php echo e(url('manager/users/add')); ?>" method="post">
                                     <?php echo csrf_field(); ?>

                                        <input type="hidden" name="user_type_id" value="3">
                                        <div class="form-group">
                                            <label for="username">Name</label>
                                            <input class="form-control" type="text" name="name"
                                                required="" placeholder="Name"  value="<?php echo e(old('name')); ?>">
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="username">Email</label>
                                            <input class="form-control" type="email" name="email" 
                                                required="" placeholder="Email"  value="<?php echo e(old('email')); ?>">
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="username">Userame</label>
                                            <input class="form-control" type="text" name="username"
                                                required="" placeholder="Username"  value="<?php echo e(old('username')); ?>">
                                        </div>
                                      
                                        <div class="form-group">
                                            <label for="username">Password</label>
                                            <input class="form-control" type="password" name="password" 
                                                required="" placeholder="Password">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Conform Password</label>
                                            <input class="form-control" type="password" name="confirm_password" 
                                                required="" placeholder="confirm Password">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Telephone</label>
                                            <input class="form-control" type="text" name="telephone" 
                                                placeholder="Telephone"  value="<?php echo e(old('telephone')); ?>">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Mobile Phone</label>
                                            <input class="form-control" type="text" name="mobile" 
                                                placeholder="Mobile Phone"  value="<?php echo e(old('mobile')); ?>">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Extension</label>
                                            <input class="form-control" type="text" name="extension" 
                                                placeholder="Extension"  value="<?php echo e(old('extension')); ?>">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Address</label>
                                            <input class="form-control" type="text" name="address" 
                                                placeholder="Extension"  value="<?php echo e(old('address')); ?>">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Date of Join</label>
                                            <input class="form-control" type="date" name="date_of_join" 
                                                placeholder="Date of Join"  value="<?php echo e(old('date_of_join')); ?>">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Designation</label>
                                            <select class="form-control" name="designation_id">
                                                <option value="">Select</option>
                                                <?php $__currentLoopData = $designations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $designation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($designation->id); ?>"  <?php echo e((old('designation_id') == $designation->id)? 'selected':''); ?>><?php echo e($designation->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                         <div class="form-group">
                                            <label for="username">Company</label>
                                            <select class="form-control" name="company_id">
                                                <option value="">Select</option>
                                                <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($company->id); ?>"  <?php echo e((old('company_id') == $company->id)? 'selected':''); ?>><?php echo e($company->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>

                                        <div class="form-group">
                                            <label for="username">Status</label>
                                            <select class="form-control"  name="status">
                                                <option value="">Select</option>
                                                <option value="1" <?php echo e((old('status')== 1)? 'selected':''); ?>>Active</option>
                                                <option value="0" <?php echo e((old('status')== 0)? 'selected':''); ?>>Inactive</option>
                                            </select>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-light"
                                                data-dismiss="modal">Close</button>
                                            <button type="submit" class="btn btn-primary">Save</button>
                                        </div>

                                    </form>

                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->
                    <div class="table-responsive">
                        <table
                            class="table table-bordered m-t-30 table-hover contact-list" data-paging="true"
                            data-paging-size="7">
                            <thead>
                                <tr>
          
                                    <th>Name</th>
                                    <th>User Type</th>
                                    <th>Last Active</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($user->name); ?></td>
                                     <td><?php echo e($user->user_types['name']); ?></td>
                                    <td>
                                        <?php if(Cache::has('user-is-online-' . $user->id)): ?>
                                           <b style="color:#4cc125;">Online</b>
                                        <?php else: ?>
                                            <?php echo e(date('d M Y',strtotime($user->updated_at))); ?>

                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($user->status == 1): ?>
                                        <span class="badge badge-success">Active</span>
                                        <?php else: ?>
                                        <span class="badge badge-danger">Inactive</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                    
                                    <a class="edit" title="Edit" style="cursor:pointer;" data-id="<?php echo e($user->id); ?>"> <i class="fas fa-pencil-alt text-inverse m-r-10"></i> </a>
                                        <a href="<?php echo e(URL::to('manager/users/' . $user->id . '/delete')); ?>" onclick="return confirm('Do you want to delete this user?')" title="Delete"> <i class="fas fa-window-close text-danger"></i> </a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <?php echo e($users->render()); ?>

                </div>

            </div>
        </div>
    </div>
</div>
<!-- Signup modal content -->
<div id="editmodal" class="modal fade" tabindex="-1" role="dialog"
    aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
           <div class="text-center mt-2 mb-4">
                <h4 class="modal-title" id="myModalLabel">Edit User</h4>
            </div>
            <div class="modal-body load_view" id="load_view">
               
            </div>
           
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascripts'); ?>
<script type="text/javascript">
$(function(){
    $('.edit').on('click',function(){
        id = $(this).data('id');       
        $('.load_view').load('<?php echo e(URL::to("manager/users/")); ?>/'+id+'/edit');
        $('#editmodal').modal('show');
    });
})
</script> 
<!-- <script type="text/javascript">
<?php if(count($errors) > 0): ?>
    $('#myModal').modal('show');
<?php endif; ?>
</script> -->

<?php $__env->stopSection(); ?>


<?php echo $__env->make('manager.layout.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/devneoli/public_html/tms/resources/views/manager/users/index.blade.php ENDPATH**/ ?>