<?php $__env->startSection('title','Tasks'); ?>
<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
<div class="row page-titles">
    <div class="col-md-5 col-12 align-self-center">
        <h3 class="text-themecolor mb-0">Tasks</h3>
        <ol class="breadcrumb mb-0 p-0 bg-transparent">
            <li class="breadcrumb-item"><a href="javascript:void(0)">Admin</a></li>
            <li class="breadcrumb-item active">Tasks</li>
        </ol>
    </div>
   
</div>
<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">
   <div class="row">
        <div class="col-12">
            <?php echo $__env->make('partials.notifications', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">Tasks</h4>
                    <h6 class="card-subtitle"></h6>
                    <button type="button" class="btn btn-info btn-rounded m-t-10 mb-2 float-right"
                        data-toggle="modal" data-target="#myModal">Add New Task</button>
                       <!-- Signup modal content -->
                    <div id="myModal" class="modal fade" tabindex="-1" role="dialog"
                        aria-hidden="true">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content">

                                <div class="modal-body">
                                    <div class="text-center mt-2 mb-4">
                                        <h4 class="modal-title" id="myModalLabel">Add Task</h4>
                                    </div>

                                    <form class="pl-3 pr-3" action="<?php echo e(url('admin/tasks/add')); ?>" method="post">
                                     <?php echo csrf_field(); ?>

                                        <div class="form-group">
                                            <label for="username">Name</label>
                                            <input class="form-control" type="text" name="name" id="name"
                                                required="" placeholder="Name">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">IN/OUT</label>
                                            <select class="form-control" required="" name="in_out">
                                                <option value="">Select</option>
                                                <option value="IN">IN</option>
                                                <option value="OUT">OUT</option>
                                                <option value="CC">CC</option>
                                                <option value="SELF">SELF</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Task Type</label>
                                            <select class="form-control" required="" name="task_type_id">
                                                <option value="">Select</option>
                                                <?php $__currentLoopData = $task_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($task_type->id); ?>"><?php echo e($task_type->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Division</label>
                                            <select class="form-control" required="" name="division_id">
                                                <option value="">Select</option>
                                                <?php $__currentLoopData = $divisions ?? ''; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $division): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($division->id); ?>"><?php echo e($division->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                           
                                            <input class="form-check-input material-inputs" type="checkbox" id="inlineCheckbox1" value="1" name="to_self">
                                            <label class="form-check-label" for="inlineCheckbox1">To Self</label>
                                        </div>
                                      
                                        <div class="form-group">
                                            <label for="username">Priority</label>
                                            <input type="text" name="priority" class="form-control" name="priority">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Descripton</label>
                                            <textarea class="form-control" name="description"></textarea>
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Company</label>
                                            <select class="form-control" required="" name="company_id">
                                                <option value="">Select</option>
                                                <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($company->id); ?>"><?php echo e($company->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Assigned staffs</label>

                                            <select class="select2 form-control" multiple="multiple" id="staffs" style="height: 36px;width: 100%;" name="staffs[]">
                                                <option value="">Select</option>
                                                <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($employee->id); ?>"><?php echo e($employee->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>

                                        <div class="form-group">
                                            <label for="username">Status</label>
                                            <select class="form-control" required="" name="status">
                                                <option value="">Select</option>
                                                <?php $__currentLoopData = $task_statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task_status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($task_status->id); ?>"><?php echo e($task_status->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>


                                      
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-light"
                                                data-dismiss="modal">Close</button>
                                            <button type="submit" class="btn btn-primary">Save</button>
                                        </div>

                                    </form>

                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->
                    <div class="row">
                        <select id="first" class="form-control col-md-3 col-sm-12">
                            <option value="">Owner</option>
                            <?php $__currentLoopData = $owners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $owner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($owner->name); ?>"><?php echo e($owner->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        &emsp;
                        <select id="second" class="form-control col-md-3 col-sm-12">
                            <option value="">Division</option>
                            <?php $__currentLoopData = $divisions ?? ''; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $division): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($division->name); ?>"><?php echo e($division->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                         &emsp;
                         <select id="third" class="form-control col-md-3 col-sm-12">
                            <option value="">Task Type</option>
                            <?php $__currentLoopData = $task_types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($task_type->name); ?>"><?php echo e($task_type->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="row" style="margin-bottom:10px;">
                        <select id="fourth" class="form-control col-md-3 col-sm-12">
                            <option value="">Company</option>
                            <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($company->name); ?>"><?php echo e($company->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        &emsp;
                        <select id="fifth" class="form-control col-md-3 col-sm-12">
                            <option value="">Status</option>
                            <!--<option value="Active">Active</option>-->
                            <!--<option value="Inactive">Inactive</option>-->
                            <?php $__currentLoopData = $task_statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task_status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($task_status->name); ?>"><?php echo e($task_status->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        &emsp;
                        <select id="sixth" class="form-control col-md-3 col-sm-12" style="margin-bottom:10px;">
                            <option value="">IN/OUT</option>
                            <option value="IN">IN</option>
                            <option value="OUT">OUT</option>
                            <option value="CC">CC</option>
                            <option value="SELF">SELF</option>
                        </select>
                        <input type="date" name="from_date" id="seventh" class="form-control col-md-3 col-sm-12">
                        &emsp;
                        <input type="date" name="to_date" id="eighth" class="form-control col-md-3 col-sm-12">
                    </div>
                    <div class="row">
                    </div>
                    <div class="table-responsive">
                        <table id="default_order" class="table table-striped table-bordered display"
                                        style="width:100%">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>IN/OUT</th>
                                    <th>Owner</th>
                                    <th>Division</th>
                                    <th>Task Type</th>
                                    <th>Name</th>
                                    <th>Company</th>
                                    <th>Updated at</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($task->task_id); ?></td>
                                    <td><?php echo e(trim($task->in_out)); ?></td>
                                    <td><?php echo e($task->owner['name']); ?></td>
                                    <td><?php echo e($task->division['name']); ?></td>
                                    <td><?php echo e($task->task_types['name']); ?></td>
                                    <td><?php echo e($task->company['name']); ?></td>
                                    <td><?php echo e($task->name); ?></td>
                                    <td><?php echo e(date('d M Y',strtotime($task->updated_at))); ?></td>
                                    <td>
                                        <!--<?php if($task->status == 1): ?>-->
                                        <!--<span class="badge badge-success">Active</span>-->
                                        <!--<?php else: ?>-->
                                        <!--<span class="badge badge-danger">Pending</span>-->
                                        <!--<?php endif; ?>-->
                                        <span class="badge" style="background-color:<?php echo e($task->task_status['color']); ?>; color:#ffffff;">
                                            <?php echo e($task->task_status['name']); ?>

                                        </span>
                                    </td>
                                    <td>
                                    
                                    <a class="edit" title="Edit" style="cursor:pointer;" href="<?php echo e(URL::to('admin/tasks/' . $task->id . '/edit')); ?>" > <i class="fas fa-pencil-alt text-inverse m-r-10"></i> </a>
                                    <a href="<?php echo e(URL::to('admin/tasks/' . $task->id . '/delete')); ?>" onclick="return confirm('Do you want to delete this task?')" title="Delete"> <i class="fas fa-window-close text-danger"></i> </a>
                                    <a class="reminder" title="Add reminder" style="cursor:pointer;" data-id="<?php echo e($task->id); ?>"> <i class=" fas fa-clock"></i> </a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <?php echo e($tasks->render()); ?>

                </div>
            </div>
        </div>
    </div>
</div>
<!-- Signup modal content -->
<div id="editmodal" class="modal fade" tabindex="-1" role="dialog"
    aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
           <div class="text-center mt-2 mb-4">
                <h4 class="modal-title" id="myModalLabel">Edit Task</h4>
            </div>
            <div class="modal-body load_view" id="load_view">
               
            </div>
           
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<!-- Signup modal content -->
<div id="remindermodal" class="modal fade" tabindex="-1" role="dialog"
    aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
           <div class="text-center mt-2 mb-4">
                <h4 class="modal-title" id="myModalLabel">Add Reminder</h4>
            </div>
            <div class="modal-body load_view" id="load_view">
               
            </div>
           
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascripts'); ?>
<script type="text/javascript">
$(function(){
    $('.edit').on('click',function(){
        id = $(this).data('id');       
        $('.load_view').load('<?php echo e(URL::to("admin/tasks/")); ?>/'+id+'/edit');
        $('#editmodal').modal('show');
    });

    $('.reminder').on('click',function(){
        id = $(this).data('id');       
        $('.load_view').load('<?php echo e(URL::to("admin/tasks/")); ?>/'+id+'/reminder');
        $('#remindermodal').modal('show');
    });
})

var table = table =  $('#default_order').DataTable( {});

$('#first').on('change', function () {
        table.columns(2).search( this.value).draw();
} );

$('#second').on('change', function () {
        table.columns(3).search( this.value).draw();
} );

$('#third').on('change', function () {
        table.columns(4).search( this.value).draw();
} );
$('#fourth').on('change', function () {
        table.columns(5).search( this.value).draw();
} );
$('#fifth').on('change', function () {
        table.columns(8).search( this.value).draw();
} );
$('#sixth').on('change', function () {
        table.columns(1).search( this.value).draw();
} );
$('#seventh').on('change', function () {
        table.columns(7).search(this.value).draw("<=");
} );
$('#eighth').on('change', function () {
        table.columns(7).search( this.value).draw();
} );

// Date Filter

$(function() {

  $("#seventh").datepicker({
    showOn: "button",
    "onSelect": function(date) {
      minDateFilter = new Date(date).getTime();
      table.fnDraw();
    }
  }).keyup(function() {
    minDateFilter = new Date(this.value).getTime();
    table.fnDraw();
  });

  $("#eighth").datepicker({
    showOn: "button",
    "onSelect": function(date) {
      maxDateFilter = new Date(date).getTime();
      table.fnDraw();
    }
  }).keyup(function() {
    maxDateFilter = new Date(this.value).getTime();
    table.fnDraw();
  });

});

// Date range filter
minDateFilter = "";
maxDateFilter = "";

$.fn.dataTableExt.afnFiltering.push(
  function(oSettings, aData, iDataIndex) {
    if (typeof aData._date == 'undefined') {
      aData._date = new Date(aData[0]).getTime();
    }

    if (minDateFilter && !isNaN(minDateFilter)) {
      if (aData._date < minDateFilter) {
        return false;
      }
    }

    if (maxDateFilter && !isNaN(maxDateFilter)) {
      if (aData._date > maxDateFilter) {
        return false;
      }
    }

    return true;
  }
);

</script> 
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layout.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\tms\resources\views/admin/tasks/index.blade.php ENDPATH**/ ?>