@extends('manager.layout.default')
@section('title','Users')
@section('content')
<div class="page-wrapper">
<div class="row page-titles">
    <div class="col-md-5 col-12 align-self-center">
        <h3 class="text-themecolor mb-0">Users</h3>
        <ol class="breadcrumb mb-0 p-0 bg-transparent">
           <!--  <li class="breadcrumb-item"><a href="javascript:void(0)">Admin</a></li> -->
            <li class="breadcrumb-item active">Users</li>
        </ol>
    </div>
   
</div>
<!-- ============================================================== -->
<!-- Container fluid  -->
<!-- ============================================================== -->
<div class="container-fluid">
   <div class="row">
        <div class="col-12">
            @include ('partials.notifications')
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">Users</h4>
                    <h6 class="card-subtitle"></h6>
                    <button type="button" class="btn btn-info btn-rounded m-t-10 mb-2 float-right"
                        data-toggle="modal" data-target="#myModal">Add New User</button>
                       <!-- Signup modal content -->
                    <div id="myModal" class="modal fade" tabindex="-1" role="dialog"
                        aria-hidden="true">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content">
                                <div class="modal-body">
                                    <div class="text-center mt-2 mb-4">
                                        <h4 class="modal-title" id="myModalLabel">Add User</h4>
                                    </div>
                                    @include ('partials.notifications')
                                    <form class="pl-3 pr-3" action="{{ url('manager/users/add') }}" method="post">
                                     {!! csrf_field() !!}
                                        <input type="hidden" name="user_type_id" value="3">
                                        <div class="form-group">
                                            <label for="username">Name</label>
                                            <input class="form-control" type="text" name="name"
                                                required="" placeholder="Name"  value="{{ old('name') }}">
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="username">Email</label>
                                            <input class="form-control" type="email" name="email" 
                                                required="" placeholder="Email"  value="{{ old('email') }}">
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="username">Userame</label>
                                            <input class="form-control" type="text" name="username"
                                                required="" placeholder="Username"  value="{{ old('username') }}">
                                        </div>
                                      
                                        <div class="form-group">
                                            <label for="username">Password</label>
                                            <input class="form-control" type="password" name="password" 
                                                required="" placeholder="Password">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Conform Password</label>
                                            <input class="form-control" type="password" name="confirm_password" 
                                                required="" placeholder="confirm Password">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Telephone</label>
                                            <input class="form-control" type="text" name="telephone" minlength="8" maxlength="15" 
                                                placeholder="Telephone"  value="{{ old('telephone') }}">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Mobile Phone</label>
                                            <input class="form-control" type="text" name="mobile"  minlength="8" maxlength="15"
                                                placeholder="Mobile Phone"  value="{{ old('mobile') }}">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Extension</label>
                                            <input class="form-control" type="text" name="extension" 
                                                placeholder="Extension"  value="{{ old('extension') }}">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Address</label>
                                            <input class="form-control" type="text" name="address" 
                                                placeholder="Extension"  value="{{ old('address') }}">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Date of Join</label>
                                            <input class="form-control" type="date" name="date_of_join" 
                                                placeholder="Date of Join"  value="{{ old('date_of_join') }}">
                                        </div>
                                        <div class="form-group">
                                            <label for="username">Designation</label>
                                            <select class="form-control" name="designation_id" required="">
                                                <option value="">Select</option>
                                                @foreach($designations as $designation)
                                                <option value="{{ $designation->id }}"  {{(old('designation_id') == $designation->id)? 'selected':''}}>{{ $designation->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                         <div class="form-group">
                                            <label for="username">Company</label>
                                            <select class="form-control" name="company_id" required="">
                                                <option value="">Select</option>
                                                @foreach($companies as $company)
                                                <option value="{{ $company->id }}"  {{(old('company_id') == $company->id)? 'selected':''}}>{{ $company->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>

                                        <div class="form-group">
                                            <label for="username">Status</label>
                                            <select class="form-control"  name="status" required="">
                                                <option value="">Select</option>
                                                <option value="1" {{(old('status')== 1)? 'selected':''}}>Active</option>
                                                <option value="0" {{(old('status')== 0)? 'selected':''}}>Inactive</option>
                                            </select>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-light"
                                                data-dismiss="modal">Close</button>
                                            <button type="submit" class="btn btn-primary">Save</button>
                                        </div>

                                    </form>

                                </div>
                            </div><!-- /.modal-content -->
                        </div><!-- /.modal-dialog -->
                    </div><!-- /.modal -->
                    <div class="table-responsive">
                        <table
                            class="table table-bordered m-t-30 table-hover contact-list" data-paging="true"
                            data-paging-size="7">
                            <thead>
                                <tr>
          
                                    <th>Name</th>
                                    <th>User Type</th>
                                    <th>Last Active</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                            @foreach($users as $user)
                                <tr>
                                    <td>{{ $user->name }}</td>
                                     <td>{{ $user->user_types['name'] }}</td>
                                    <td>
                                        @if(Cache::has('user-is-online-' . $user->id))
                                           <b style="color:#4cc125;">Online</b>
                                        @else
                                            {{ date('d M Y',strtotime($user->updated_at)) }}
                                        @endif
                                    </td>
                                    <td>
                                        @if($user->status == 1)
                                        <span class="badge badge-success">Active</span>
                                        @else
                                        <span class="badge badge-danger">Inactive</span>
                                        @endif
                                    </td>
                                    <td>
                                    
                                    <a class="edit" title="Edit" style="cursor:pointer;" data-id="{{ $user->id }}"> <i class="fas fa-pencil-alt text-inverse m-r-10"></i> </a>
                                        <a href="{{URL::to('manager/users/' . $user->id . '/delete')}}" onclick="return confirm('Do you want to delete this user?')" title="Delete"> <i class="fas fa-window-close text-danger"></i> </a>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                    {{ $users->render() }}
                </div>

            </div>
        </div>
    </div>
</div>
<!-- Signup modal content -->
<div id="editmodal" class="modal fade" tabindex="-1" role="dialog"
    aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
           <div class="text-center mt-2 mb-4">
                <h4 class="modal-title" id="myModalLabel">Edit User</h4>
            </div>
            <div class="modal-body load_view" id="load_view">
               
            </div>
           
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
@endsection
@section('javascripts')
<script type="text/javascript">
$(function(){
    $('.edit').on('click',function(){
        id = $(this).data('id');       
        $('.load_view').load('{{URL::to("manager/users/")}}/'+id+'/edit');
        $('#editmodal').modal('show');
    });
})
</script> 
<!-- <script type="text/javascript">
@if (count($errors) > 0)
    $('#myModal').modal('show');
@endif
</script> -->

@endsection

