<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	/**
	 * Run the migrations.
	 *
	 * @return void
	 */
	public function up()
	{
		Schema::create('users', function(Blueprint $table)
		{
			$table->integer('id', true);
			$table->string('first_name', 250)->nullable();
			$table->string('last_name', 250)->nullable();
			$table->integer('user_type_id')->nullable();
			$table->string('email', 250)->nullable();
			$table->string('password', 250)->nullable();
			$table->string('phone', 500)->nullable();
			$table->string('profile_picture', 500)->nullable();			
			$table->integer('status')->nullable();
			$table->string('remember_token', 250)->nullable();
			$table->string('last_login', 250)->nullable();
			$table->timestamps();
		});
	}


	/**
	 * Reverse the migrations.
	 *
	 * @return void
	 */
	public function down()
	{
		Schema::drop('users');
	}

}
