<?php

namespace App;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Cache;

class User extends Authenticatable
{
    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];


       
    /* Method to hash password automatically*/
    public function setPasswordAttribute($pass){
        $this->attributes['password'] = \Hash::make($pass);
    }

    public function user_types(){
       return $this->belongsTo('App\UserType', 'user_type_id');  
    }

    public function companies(){
       return $this->belongsTo('App\Company', 'company_id');  
    }




}
