<?php namespace App;

use Illuminate\Database\Eloquent\Model;


class Task extends Model {
    
    protected $table = 'tasks';


    public function reminder(){
       return $this->hasOne('App\Reminder');  
    }

    public function task_types(){
       return $this->belongsTo('App\TaskType', 'task_type_id');  
    }
    
    public function task_status(){
       return $this->belongsTo('App\TaskStatus', 'status');  
    }

    public function owner(){
       return $this->belongsTo('App\User', 'adduser_id');  
    }

    public function division(){
       return $this->belongsTo('App\Division', 'division_id');  
    }
    
    public function company(){
       return $this->belongsTo('App\Company', 'company_id');  
    }





}
