<?php namespace App\Http\Controllers;
use Illuminate\Support\Faccontactes\Validator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Pusher\Pusher;
use Session;
use Redirect;
use Auth;
use DB;
class TasksController extends Controller {

    /* Admin to add tasks
    *  23-01-2021
    */
    public function addTasks(Request $req){
      
        return view('admin.tasks.add');
    }
     
    /* Admin to add tasks
    *  23-01-2021
    */
    public function addPostTasks(Request $req){
        
        $task                = new \App\Task;
        $task->name          = $req->input('name');
        $task->task_id       = rand ( 10000 , 99999 );
        $task->task_type_id  = $req->input('task_type_id');
        $task->division_id   = $req->input('division_id');
        $task->adduser_id    = Auth::id();
        $task->description   = $req->input('description');
        
        if($req->file('attachment')) {
            $req->validate([
                'attachment' => 'required|max:2048',
            ]);
            $fileName = time().'.'.$req->file('attachment')->extension();
            $req->file('attachment')->storeAs('uploads',$fileName);
            $task->attachment   = $fileName;
        }
        
        $task->priority     = $req->input('priority');
        $task->in_out       = $req->input('in_out');
        $task->to_self      = $req->input('to_self');
        $task->company_id   = $req->input('company_id');
        $task->users        = json_encode($req->input('staffs'));
        $task->cc           = $req->input('cc');
        $task->status       = $req->input('status');
        $task->save();
        return Redirect::to('admin/tasks')->with('success', 'Task added successfully!');
      

        
    }

    public function reminder(Request $req,$id){


        $task  = \App\Task::where('id',$id)
                ->first();
        $reminder = \App\Reminder::where('task_id',$id)->first();

        return view('admin.tasks.reminder',['task' => $task,'reminder'=>$reminder]);
    }

    /* Admin to edit tasks
    *  23-01-2021
    */
    public function editTasks(Request $req,$id){


        $task  = \App\Task::where('id',$id)
                ->first();


        $task_types = \App\TaskType::get();
        $task_status = \App\TaskStatus::get();
        $employees = \App\User::where('user_type_id',3)->get();

        $companies = \App\Company::get();
        $user_ids = json_decode($task->users);
        $cc = $task->cc;

        $divisions = \App\Division::get();

        return view('admin.tasks.edit',['task' => $task,'task_types'=>$task_types,'task_statuses'=>$task_status,'employees'=>$employees,'user_ids'=>$user_ids,'companies'=>$companies,'divisions'=>$divisions,'cc'=>$cc]);
    }

    /* Admin to add tasks
    *  23-01-2021
    */
    public function postreminder(Request $req){
        
        $reminder                   = \App\Reminder::firstOrNew(array('task_id' => $req->input('task_id')));
        $reminder->date_time        = $req->input('date');
        $reminder->subject          = $req->input('subject');
        $reminder->other_subject    = $req->input('other_subject');
        

        $reminder->save();

        return Redirect::to('admin/tasks')->with('success', 'Reminder updated successfully!');
        
    }

     
    /* Admin to add tasks
    *  23-01-2021
    */
    public function editPostTasks(Request $req){

        $id = $req->input('id');
    
        $task                = \App\Task::findOrFail($id);
        $task->name          = $req->input('name');
        $task->task_type_id  = $req->input('task_type_id');
        $task->division_id   = $req->input('division_id');
        $task->adduser_id    = Auth::id();
        $task->description   = $req->input('description');
        
        if($req->file('attachment')) {
            $req->validate([
                'attachment' => 'required|max:2048',
            ]);
            $fileName = time().'.'.$req->file('attachment')->extension();
            $req->file('attachment')->storeAs('uploads',$fileName);
            $task->attachment   = $fileName;
        }
        
        $task->priority     = $req->input('priority');
        $task->in_out       = $req->input('in_out');
        $task->to_self      = $req->input('to_self');
        $task->company_id   = $req->input('company_id');
        $task->users        = json_encode($req->input('staffs'));
        $task->cc           = $req->input('cc');
        $task->status       = $req->input('status');

        $task->save();

        return Redirect::to('admin/tasks')->with('success', 'Task updated successfully!');
   

        
    }

    /* Admin list contacts page
    *  17-03-2020
    */
    public function getTasks(){

        $tasks = \App\Task::paginate(15);
        $task_types = \App\TaskType::get();
        $task_statuses = \App\TaskStatus::get();
        $employees = \App\User::where('user_type_id',3)->get();
        $cc = \App\User::whereIn('user_type_id',['2','3'])->get();
        $companies = \App\Company::get();
        $divisions = \App\Division::get();
        $owners = \App\User::where('user_type_id','<>',1)->get();

        return view('admin.tasks.index',['tasks'=>$tasks,'task_types'=>$task_types,'task_statuses'=>$task_statuses,'employees'=>$employees,'companies'=>$companies,'divisions'=>$divisions,'owners'=>$owners, 'cc'=>$cc]);

    }

      /* Admin list contacts page
    *  17-03-2020
    */
    public function getManagerTasks(){

        // $tasks = \App\Task::where('adduser_id',Auth::id())->paginate(15);
        $company_id = \App\User::where('id',Auth::id())->value('company_id');
        $tasks = \App\Task::where('company_id',$company_id)->paginate(15);
        $task_types = \App\TaskType::get();
        $employees = \App\User::where('user_type_id',3)->where('company_id',$company_id)->get();
        $companies = \App\Company::where('id',$company_id)->get();
        $owners = \App\User::where('user_type_id','<>',3)->get();
        $task_statuses = \App\TaskStatus::get();
        return view('manager.tasks.index',['tasks'=>$tasks,'task_types'=>$task_types,'employees'=>$employees,'companies'=>$companies, 'owners'=>$owners, 'task_statuses'=>$task_statuses]);

    }


   /* Admin list contacts page
    *  17-03-2020
    */
    public function getEmployeeTasks(){
        $tasks = \App\Task::whereJsonContains('users',["".Auth::id().""])->paginate(15);
        $task_types = \App\TaskType::get();
        $employees = \App\User::where('user_type_id',3)->get();
        $companies = \App\Company::get();
        $owners = \App\User::where('user_type_id','<>',3)->get();
        $task_statuses = \App\TaskStatus::get();
        return view('employee.tasks.index',['tasks'=>$tasks,'task_types'=>$task_types,'employees'=>$employees,'companies'=>$companies,'owners'=>$owners,'task_statuses'=>$task_statuses]);

    }


    /* Admin view contact details
    *  13-03-2019
    */
    public function taskView(Request $req,$id){
    
        $task  = \App\Task::where('id',$id)
             ->first();
        return view('admin.tasks.view',['task'=>$task]);
    
    }

    /* To delete contact
    *  13-03-2020
    */
    public function TasksDelete($id){
        if(!empty($id)){
            $task = \App\Task::findOrFail($id);
            $file = $task->attachment;
            if($file) {
                // Storage::delete($file, 'uploads');
                unlink(storage_path('app/uploads/'.$file));
            }
            if($task){
                \App\Task::destroy($id);
                return Redirect::to('admin/tasks')->with('success', 'Task deleted successfully!');
            }
        }else{
            return Redirect::to('admin/tasks')->with('error', 'You cannot delete!');
        }
    }

    public function reminderdelete($id){
        if(!empty($id)){
            $reminder = \App\Reminder::findOrFail($id);
            if($reminder){
                \App\Reminder::destroy($id);
                return Redirect::to('admin/tasks')->with('success', 'Reminder deleted successfully!');
            }
        }else{
            return Redirect::to('admin/tasks')->with('error', 'You cannot delete!');
        }
    }
    
    public function viewAdminTasks(Request $req,$id){


        $task  = \App\Task::where('id',$id)->first();
        $task_status = \App\TaskStatus::get();

        $task_types = \App\TaskType::get();
        $employees = \App\User::where('user_type_id',3)->get();

        
        $user_ids = json_decode($task->users);

        return view('admin.tasks.view',['task' => $task, 'task_statuses'=>$task_status,'task_types'=>$task_types,'employees'=>$employees,'user_ids'=>$user_ids]);
    }
    
    public function editProgress(Request $req){

        $id = $req->input('id');
    
        $task               = \App\Task::findOrFail($id);
        $task->progress     = $req->input('progress');
        $task->status       = $req->input('status');

        $task->save();

        return Redirect::to('admin/tasks')->with('success', 'Task progress updated successfully!');
        
    }

    public function ManagerTasksDelete($id){
        if(!empty($id)){
            $task = \App\Task::findOrFail($id);
            if($task){
                \App\Task::destroy($id);
                return Redirect::to('manager/tasks')->with('success', 'Task deleted successfully!');
            }
        }else{
            return Redirect::to('manager/tasks')->with('error', 'You cannot delete!');
        }
    }


    public function addManagerTasks(Request $req){
      
        return view('admin.tasks.add');
    }
     
    /* Admin to add tasks
    *  23-01-2021
    */
    public function addPostManagerTasks(Request $req){
        
        $task                = new \App\Task;
        $task->name          = $req->input('name');
        $task->task_id       = rand ( 10000 , 99999 );
        $task->task_type_id  = $req->input('task_type_id');
        $task->adduser_id    = Auth::id();
        $task->description   = $req->input('description');
        
        if($req->file('attachment')) {
            $req->validate([
                'attachment' => 'required|max:2048',
            ]);
            $fileName = time().'.'.$req->file('attachment')->extension();
            $req->file('attachment')->storeAs('uploads',$fileName);
            $task->attachment   = $fileName;
        }
        $task->priority      = $req->input('priority');
        $task->in_out        = $req->input('in_out');
        $task->to_self       = $req->input('to_self');
        $task->company_id    = \App\User::where('id',Auth::id())->value('company_id');
        $task->users         = json_encode($req->input('staffs'));
        $task->status        = $req->input('status');
        $task->save();
        return Redirect::to('manager/tasks')->with('success', 'Task added successfully!');
      

        
    }

    /* Admin to edit tasks
    *  23-01-2021
    */
    public function editManagerTasks(Request $req,$id){


        $task  = \App\Task::where('id',$id)
                ->first();


        $task_types = \App\TaskType::get();
        $employees = \App\User::where('user_type_id',3)->where('add_user',Auth::id())->get();

        $user_ids = json_decode($task->users);

        return view('manager.tasks.edit',['task' => $task,'task_types'=>$task_types,'employees'=>$employees,'user_ids'=>$user_ids]);
    }
     
    /* Admin to add tasks
    *  23-01-2021
    */
    public function editPostManagerTasks(Request $req){

        $id = $req->input('id');
    
        $task                = \App\Task::findOrFail($id);
        $task->name          = $req->input('name');
        $task->task_type_id  = $req->input('task_type_id');
        $task->adduser_id    = Auth::id();
        $task->description   = $req->input('description');
        
        if($req->file('attachment')) {
            $req->validate([
                'attachment' => 'required|max:2048',
            ]);
            $fileName = time().'.'.$req->file('attachment')->extension();
            $req->file('attachment')->storeAs('uploads',$fileName);
            $task->attachment   = $fileName;
        }
        
        $task->priority      = $req->input('priority');
        $task->in_out        = $req->input('in_out');
        $task->to_self       = $req->input('to_self');
        $task->company_id    = \App\User::where('id',Auth::id())->value('company_id');
        $task->users         = json_encode($req->input('staffs'));
        $task->status        = $req->input('status');

        $task->save();

        return Redirect::to('manager/tasks')->with('success', 'Task updated successfully!');
   

        
    }
    
    public function viewManagerTasks(Request $req,$id){


        $task  = \App\Task::where('id',$id)->first();
        $task_status = \App\TaskStatus::get();

        $task_types = \App\TaskType::get();
        $employees = \App\User::where('user_type_id',3)->get();

        
        $user_ids = json_decode($task->users);

        return view('manager.tasks.view',['task' => $task, 'task_statuses'=>$task_status,'task_types'=>$task_types,'employees'=>$employees,'user_ids'=>$user_ids]);
    }
    
    public function editManagerProgress(Request $req){

        $id = $req->input('id');
    
        $task               = \App\Task::findOrFail($id);
        $task->progress     = $req->input('progress');
        $task->status       = $req->input('status');

        $task->save();

        return Redirect::to('manager/tasks')->with('success', 'Task progress updated successfully!');
        
    }

    //Employeee

    public function addEmployeeTasks(Request $req){
      
        return view('employee.tasks.add');
    }
     
    /* Admin to add tasks
    *  23-01-2021
    */
    public function addPostEmployeeTasks(Request $req){
        
        $task                = new \App\Task;
        $task->name          = $req->input('name');
        $task->task_id       = rand ( 10000 , 99999 );
        $task->task_type_id  = $req->input('task_type_id');
        $task->adduser_id    = Auth::id();
        $task->description   = $req->input('description');
        
        if($req->file('attachment')) {
            $req->validate([
                'attachment' => 'required|max:2048',
            ]);
            $fileName = time().'.'.$req->file('attachment')->extension();
            $req->file('attachment')->storeAs('uploads',$fileName);
            $task->attachment   = $fileName;
        }
        
        $task->priority      = $req->input('priority');
        $task->in_out        = $req->input('in_out');
        $task->to_self       = 1;
        $task->company_id    = \App\User::where('id',Auth::id())->value('company_id');
        $task->users         = '["'.Auth::id().'"]';
        $task->status        = $req->input('status');
        $task->save();
        return Redirect::to('employee/tasks')->with('success', 'Task added successfully!');
      

        
    }

    /* Admin to edit tasks
    *  23-01-2021
    */
    public function editEmployeeTasks(Request $req,$id){


        $task  = \App\Task::where('id',$id)->first();
        $task_status = \App\TaskStatus::get();


        $task_types = \App\TaskType::get();
        $employees = \App\User::where('user_type_id',3)->get();

        
        $user_ids = json_decode($task->users);

        return view('employee.tasks.edit',['task' => $task, 'task_statuses'=>$task_status,'task_types'=>$task_types,'employees'=>$employees,'user_ids'=>$user_ids]);
    }
     
    /* Admin to add tasks
    *  23-01-2021
    */
    public function editPostEmployeeTasks(Request $req){

        $id = $req->input('id');
    
        $task                = \App\Task::findOrFail($id);
        $task->name          = $req->input('name');
        $task->task_type_id  = $req->input('task_type_id');
        $task->adduser_id    = Auth::id();
        $task->description   = $req->input('description');
        
        if($req->file('attachment')) {
            $req->validate([
                'attachment' => 'required|max:2048',
            ]);
            $fileName = time().'.'.$req->file('attachment')->extension();
            $req->file('attachment')->storeAs('uploads',$fileName);
            $task->attachment   = $fileName;
        }
        
        $task->priority      = $req->input('priority');
        $task->in_out        = $req->input('in_out');
        $task->to_self       = 1;
        $task->company_id    = \App\User::where('id',Auth::id())->value('company_id');
        $task->users         = json_encode(Auth::id());
        $task->status        = $req->input('status');

        $task->save();

        return Redirect::to('employee/tasks')->with('success', 'Task updated successfully!');
   

        
    }
    
    public function viewEmployeeTasks(Request $req,$id){


        $task  = \App\Task::where('id',$id)->first();
        $task_status = \App\TaskStatus::get();
        
        if($task->status==3) {
            $task->status = 4;
            $task->save();
        }


        $task_types = \App\TaskType::get();
        $employees = \App\User::where('user_type_id',3)->get();

        
        $user_ids = json_decode($task->users);

        return view('employee.tasks.view',['task' => $task, 'task_statuses'=>$task_status,'task_types'=>$task_types,'employees'=>$employees,'user_ids'=>$user_ids]);
    }

    public function history(Request $req,$id){


        $task  = \App\Task::where('id',$id)->first();
        $history = \App\TaskHistory::where('task_id',$id)->get();
        $employees = \App\User::where('user_type_id',3)->get();
        $companies = \App\Company::get();
        
        $my_id = Auth::id();
        $user_type = \App\User::where('id',$my_id)->value('user_type_id');
        $user_id = json_decode($task['user']);
        \App\Message::where(['from' => $user_id, 'to' => $my_id])->update(['is_read' => '1']);
        $messages = \App\Message::where(function($query) use ($user_id, $my_id) {
            $query->where('from', $my_id)->where('to', $user_id);
        })->orWhere(function($query) use ($user_id, $my_id) {
            $query->where('from', $user_id)->where('to', $my_id);
        })->get();
        if($user_type==1) {
            return view('admin.tasks.history',['task' => $task,'history'=>$history,'companies'=>$companies,'employees'=>$employees, 'messages'=>$messages]);
        }
        elseif($user_type==2) {
            return view('manager.tasks.history',['task' => $task,'history'=>$history,'companies'=>$companies,'employees'=>$employees, 'messages'=>$messages]);
        }
        elseif($user_type==3) {
            return view('employee.tasks.history',['task' => $task,'history'=>$history,'companies'=>$companies,'employees'=>$employees, 'messages'=>$messages]);
        }
    }
    
    public function taskTransfer(Request $req){
    
        $taskhistory                = new \App\TaskHistory;
        $taskhistory->task_id       = $req->input('transfer_task_id');
        $taskhistory->created_by    = $req->input('transfer_created_by');
        $taskhistory->transfer_from = Auth::id();
        $taskhistory->transfer_to   = $req->input('transfer_to');

        $taskhistory->save();
        
        $id                         = $req->input('transfer_task_id');
        $task                       = \App\Task::where('id',$id)->first();
        $task->company_id           = $req->input('transfer_company');
        $task->users                = "[".json_encode($req->input('transfer_to'))."]";
        
        $task->save();
        
        $my_id = Auth::id();
        $user_type = \App\User::where('id',$my_id)->value('user_type_id');
        
        if($user_type==1) {
            return Redirect::to('admin/tasks')->with('success', 'Task transfered successfully!');
        }
        elseif($user_type==2) {
            return Redirect::to('manager/tasks')->with('success', 'Task transfered successfully!');
        }
        elseif($user_type==3) {
            return Redirect::to('employee/tasks')->with('success', 'Task transfered successfully!');
        }
        
    }
    
    public function editEmployeeProgress(Request $req){

        $id = $req->input('id');
    
        $task               = \App\Task::findOrFail($id);
        $task->progress     = $req->input('progress');
        $task->status       = $req->input('status');

        $task->save();

        return Redirect::to('employee/tasks')->with('success', 'Task progress updated successfully!');
        
    }
    
    public function chat($id){


        $task  = \App\Task::where('id',$id)->first();
        $task_id  = \App\Task::where('id',$id)->pluck('id')->first();
        
        $my_id = Auth::id();
        $user_type = \App\User::where('id',$my_id)->value('user_type_id');
        $user_id = json_decode($task['user']);
        \App\Message::where(['from' => $user_id, 'to' => $my_id])->update(['is_read' => '1']);
        $messages = \App\Message::where('task_id', $task_id)->get();
        if($user_type==1) {
            return view('admin.tasks.chat',['task' => $task, 'messages'=>$messages]);
        }
        elseif($user_type==2) {
            return view('manager.tasks.chat',['task' => $task, 'messages'=>$messages]);
        }
        elseif($user_type==3) {
            return view('employee.tasks.chat',['task' => $task, 'messages'=>$messages, 'task_id'=> $task_id]);
        }
    }

    public function download($attachment) {
        return Storage::download('uploads/'.$attachment);
    }
    
    public function sendTaskChat(Request $request) {
        $from = Auth::id();
        $to = 1;
        $message = $request->message;
        $task_id = $request->task_id;
        
        $data = new \App\Message;
        $data->from = $from;
        $data->task_id = $task_id;
        $data->message = $message;
        $data->is_read = '0';
        $data->save();
        
        $options = array(
            'cluster' => 'ap2',
            'useTLS' => true
        );

        $pusher = new Pusher(
            env('PUSHER_APP_KEY'),
            env('PUSHER_APP_SECRET'),
            env('PUSHER_APP_ID'),
            $options
        );

        $data = ['from' => $from, 'task_id' => $task_id]; // sending from and to user id when pressed enter
        $pusher->trigger('my-channel', 'my-event', $data);
    }

}
