<?php namespace App\Http\Controllers;
use Illuminate\Support\Faccontactes\Validator;
use Illuminate\Http\Request;
use Session;
use Redirect;
use Auth;
use DB;
class DivisionsController extends Controller {

    /* Admin to add divisions
    *  23-01-2021
    */
    public function addDivisions(Request $req){
      
        return view('admin.divisions.add');
    }
     
    /* Admin to add divisions
    *  23-01-2021
    */
    public function addPostDivisions(Request $req){
        
        $division                = new \App\Division;
        $division->name          = $req->input('name');
        $division->status        = $req->input('status');
        $division->save();
        return Redirect::to('admin/divisions')->with('success', 'Division added successfully!');
      

        
    }

    /* Admin to edit divisions
    *  23-01-2021
    */
    public function editDivisions(Request $req,$id){


        $division  = \App\Division::where('id',$id)
                ->first();

      
        return view('admin.divisions.edit',['division' => $division]);
    }
     
    /* Admin to add divisions
    *  23-01-2021
    */
    public function editPostDivisions(Request $req){

        $id = $req->input('id');
    
        $division                = \App\Division::findOrFail($id);
        $division->name          = $req->input('name');
        $division->status        = $req->input('status');
        $division->save();
        return Redirect::to('admin/divisions')->with('success', 'Division updated successfully!');
   

        
    }

    /* Admin list contacts page
    *  17-03-2020
    */
    public function getDivisions(){

        $divisions = \App\Division::paginate(15);
        return view('admin.divisions.index',['divisions'=>$divisions]);

    }

    /* Admin view contact details
    *  13-03-2019
    */
    public function divisionView(Request $req,$id){
    
        $division  = \App\Division::where('id',$id)
             ->first();
        return view('admin.divisions.view',['division'=>$division]);
    
    }

    /* To delete contact
    *  13-03-2020
    */
    public function DivisionsDelete($id){
        if(!empty($id)){
            $division = \App\Division::findOrFail($id);
            if($division){
                \App\Division::destroy($id);
                return Redirect::to('admin/divisions')->with('success', 'Division deleted successfully!');
            }
        }else{
            return Redirect::to('admin/divisions')->with('error', 'You cannot delete!');
        }
    }

    /*Admin change status of divisions
    * 23-01-2021
    */
    public function changeStatus(Request $req){

        $id             = $req->input('id');
        $status         = $req->input('status');
       
        $data           = $req->input('data');
        $division  = \App\Division::findOrFail($id);
        if($division){

            if($data == 1){
                
                $division->status = $status;

            }else{
                
                if($status == 1){
                
                    $division->status = 0;
                
                }else{
                
                    $division->status = 1;
                
                }   
            
            }
            
            $division->save();
            return Redirect::back()->with('success', 'Status changed successfully.');

        }
    }
   


}
